package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__stringMin1Max512PatternSS
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AllowListCriteria(
    regex: Optional[__stringMin1Max512PatternSS] = Optional.Absent,
    s3WordsList: Optional[zio.aws.macie2.model.S3WordsList] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AllowListCriteria = {
    import AllowListCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AllowListCriteria
      .builder()
      .optionallyWith(regex.map(value => value: java.lang.String))(_.regex)
      .optionallyWith(s3WordsList.map(value => value.buildAwsValue()))(
        _.s3WordsList
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AllowListCriteria.ReadOnly =
    zio.aws.macie2.model.AllowListCriteria.wrap(buildAwsValue())
}
object AllowListCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AllowListCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AllowListCriteria =
      zio.aws.macie2.model.AllowListCriteria(
        regex.map(value => value),
        s3WordsList.map(value => value.asEditable)
      )
    def regex: Optional[__stringMin1Max512PatternSS]
    def s3WordsList: Optional[zio.aws.macie2.model.S3WordsList.ReadOnly]
    def getRegex: ZIO[Any, AwsError, __stringMin1Max512PatternSS] =
      AwsError.unwrapOptionField("regex", regex)
    def getS3WordsList
        : ZIO[Any, AwsError, zio.aws.macie2.model.S3WordsList.ReadOnly] =
      AwsError.unwrapOptionField("s3WordsList", s3WordsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AllowListCriteria
  ) extends zio.aws.macie2.model.AllowListCriteria.ReadOnly {
    override val regex: Optional[__stringMin1Max512PatternSS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regex())
        .map(value => value: __stringMin1Max512PatternSS)
    override val s3WordsList
        : Optional[zio.aws.macie2.model.S3WordsList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3WordsList())
        .map(value => zio.aws.macie2.model.S3WordsList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AllowListCriteria
  ): zio.aws.macie2.model.AllowListCriteria.ReadOnly = new Wrapper(impl)
}
