package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateResourceProfileRequest(
    resourceArn: __string,
    sensitivityScoreOverride: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateResourceProfileRequest = {
    import UpdateResourceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateResourceProfileRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .optionallyWith(sensitivityScoreOverride.map(value => value: Integer))(
        _.sensitivityScoreOverride
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UpdateResourceProfileRequest.ReadOnly =
    zio.aws.macie2.model.UpdateResourceProfileRequest.wrap(buildAwsValue())
}
object UpdateResourceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateResourceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateResourceProfileRequest =
      zio.aws.macie2.model.UpdateResourceProfileRequest(
        resourceArn,
        sensitivityScoreOverride.map(value => value)
      )
    def resourceArn: __string
    def sensitivityScoreOverride: Optional[__integer]
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
    def getSensitivityScoreOverride: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("sensitivityScoreOverride", sensitivityScoreOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateResourceProfileRequest
  ) extends zio.aws.macie2.model.UpdateResourceProfileRequest.ReadOnly {
    override val resourceArn: __string = impl.resourceArn(): __string
    override val sensitivityScoreOverride: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sensitivityScoreOverride())
        .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateResourceProfileRequest
  ): zio.aws.macie2.model.UpdateResourceProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
