package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TagCriterionPairForJob(
    key: Optional[__string] = Optional.Absent,
    value: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob = {
    import TagCriterionPairForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.TagCriterionPairForJob.ReadOnly =
    zio.aws.macie2.model.TagCriterionPairForJob.wrap(buildAwsValue())
}
object TagCriterionPairForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.TagCriterionPairForJob =
      zio.aws.macie2.model.TagCriterionPairForJob(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Optional[__string]
    def value: Optional[__string]
    def getKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob
  ) extends zio.aws.macie2.model.TagCriterionPairForJob.ReadOnly {
    override val key: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: __string)
    override val value: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob
  ): zio.aws.macie2.model.TagCriterionPairForJob.ReadOnly = new Wrapper(impl)
}
