package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BucketCriteriaAdditionalProperties(
    eq: Optional[Iterable[__string]] = Optional.Absent,
    gt: Optional[__long] = Optional.Absent,
    gte: Optional[__long] = Optional.Absent,
    lt: Optional[__long] = Optional.Absent,
    lte: Optional[__long] = Optional.Absent,
    neq: Optional[Iterable[__string]] = Optional.Absent,
    prefix: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties = {
    import BucketCriteriaAdditionalProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties
      .builder()
      .optionallyWith(
        eq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eq)
      .optionallyWith(gt.map(value => value: java.lang.Long))(_.gt)
      .optionallyWith(gte.map(value => value: java.lang.Long))(_.gte)
      .optionallyWith(lt.map(value => value: java.lang.Long))(_.lt)
      .optionallyWith(lte.map(value => value: java.lang.Long))(_.lte)
      .optionallyWith(
        neq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.neq)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly =
    zio.aws.macie2.model.BucketCriteriaAdditionalProperties
      .wrap(buildAwsValue())
}
object BucketCriteriaAdditionalProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketCriteriaAdditionalProperties =
      zio.aws.macie2.model.BucketCriteriaAdditionalProperties(
        eq.map(value => value),
        gt.map(value => value),
        gte.map(value => value),
        lt.map(value => value),
        lte.map(value => value),
        neq.map(value => value),
        prefix.map(value => value)
      )
    def eq: Optional[List[__string]]
    def gt: Optional[__long]
    def gte: Optional[__long]
    def lt: Optional[__long]
    def lte: Optional[__long]
    def neq: Optional[List[__string]]
    def prefix: Optional[__string]
    def getEq: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("eq", eq)
    def getGt: ZIO[Any, AwsError, __long] = AwsError.unwrapOptionField("gt", gt)
    def getGte: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("gte", gte)
    def getLt: ZIO[Any, AwsError, __long] = AwsError.unwrapOptionField("lt", lt)
    def getLte: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("lte", lte)
    def getNeq: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("neq", neq)
    def getPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties
  ) extends zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly {
    override val eq: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.eq())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val gt: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.gt())
      .map(value => value: __long)
    override val gte: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.gte())
      .map(value => value: __long)
    override val lt: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.lt())
      .map(value => value: __long)
    override val lte: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.lte())
      .map(value => value: __long)
    override val neq: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.neq())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val prefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties
  ): zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly =
    new Wrapper(impl)
}
