package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait JobType {
  def unwrap: software.amazon.awssdk.services.macie2.model.JobType
}
object JobType {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.JobType
  ): zio.aws.macie2.model.JobType = value match {
    case software.amazon.awssdk.services.macie2.model.JobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.JobType.ONE_TIME =>
      val r = ONE_TIME
      r
    case software.amazon.awssdk.services.macie2.model.JobType.SCHEDULED =>
      val r = SCHEDULED
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.JobType {
    override def unwrap: software.amazon.awssdk.services.macie2.model.JobType =
      software.amazon.awssdk.services.macie2.model.JobType.UNKNOWN_TO_SDK_VERSION
  }
  case object ONE_TIME extends zio.aws.macie2.model.JobType {
    override def unwrap: software.amazon.awssdk.services.macie2.model.JobType =
      software.amazon.awssdk.services.macie2.model.JobType.ONE_TIME
  }
  case object SCHEDULED extends zio.aws.macie2.model.JobType {
    override def unwrap: software.amazon.awssdk.services.macie2.model.JobType =
      software.amazon.awssdk.services.macie2.model.JobType.SCHEDULED
  }
}
