package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableOrganizationAdminAccountRequest(
    adminAccountId: __string,
    clientToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest = {
    import EnableOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest
      .builder()
      .adminAccountId(adminAccountId: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.macie2.model.EnableOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object EnableOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.EnableOrganizationAdminAccountRequest =
      zio.aws.macie2.model.EnableOrganizationAdminAccountRequest(
        adminAccountId,
        clientToken.map(value => value)
      )
    def adminAccountId: __string
    def clientToken: Optional[__string]
    def getAdminAccountId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(adminAccountId)
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest
  ) extends zio.aws.macie2.model.EnableOrganizationAdminAccountRequest.ReadOnly {
    override val adminAccountId: __string = impl.adminAccountId(): __string
    override val clientToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest
  ): zio.aws.macie2.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
