package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMasterAccountResponse(
    master: Optional[zio.aws.macie2.model.Invitation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetMasterAccountResponse = {
    import GetMasterAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetMasterAccountResponse
      .builder()
      .optionallyWith(master.map(value => value.buildAwsValue()))(_.master)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetMasterAccountResponse.ReadOnly =
    zio.aws.macie2.model.GetMasterAccountResponse.wrap(buildAwsValue())
}
object GetMasterAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetMasterAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetMasterAccountResponse =
      zio.aws.macie2.model
        .GetMasterAccountResponse(master.map(value => value.asEditable))
    def master: Optional[zio.aws.macie2.model.Invitation.ReadOnly]
    def getMaster
        : ZIO[Any, AwsError, zio.aws.macie2.model.Invitation.ReadOnly] =
      AwsError.unwrapOptionField("master", master)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetMasterAccountResponse
  ) extends zio.aws.macie2.model.GetMasterAccountResponse.ReadOnly {
    override val master: Optional[zio.aws.macie2.model.Invitation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.master())
        .map(value => zio.aws.macie2.model.Invitation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetMasterAccountResponse
  ): zio.aws.macie2.model.GetMasterAccountResponse.ReadOnly = new Wrapper(impl)
}
