package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WeeklySchedule(
    dayOfWeek: Optional[zio.aws.macie2.model.DayOfWeek] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.WeeklySchedule = {
    import WeeklySchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.WeeklySchedule
      .builder()
      .optionallyWith(dayOfWeek.map(value => value.unwrap))(_.dayOfWeek)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.WeeklySchedule.ReadOnly =
    zio.aws.macie2.model.WeeklySchedule.wrap(buildAwsValue())
}
object WeeklySchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.WeeklySchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.WeeklySchedule =
      zio.aws.macie2.model.WeeklySchedule(dayOfWeek.map(value => value))
    def dayOfWeek: Optional[zio.aws.macie2.model.DayOfWeek]
    def getDayOfWeek: ZIO[Any, AwsError, zio.aws.macie2.model.DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.WeeklySchedule
  ) extends zio.aws.macie2.model.WeeklySchedule.ReadOnly {
    override val dayOfWeek: Optional[zio.aws.macie2.model.DayOfWeek] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dayOfWeek())
        .map(value => zio.aws.macie2.model.DayOfWeek.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.WeeklySchedule
  ): zio.aws.macie2.model.WeeklySchedule.ReadOnly = new Wrapper(impl)
}
