package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait LastRunErrorStatusCode {
  def unwrap
      : software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode
}
object LastRunErrorStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode
  ): zio.aws.macie2.model.LastRunErrorStatusCode = value match {
    case software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.LastRunErrorStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode =
      software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.macie2.model.LastRunErrorStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode =
      software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode.NONE
  }
  case object ERROR extends zio.aws.macie2.model.LastRunErrorStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode =
      software.amazon.awssdk.services.macie2.model.LastRunErrorStatusCode.ERROR
  }
}
