package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__string, __integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetUsageStatisticsRequest(
    filterBy: Optional[Iterable[zio.aws.macie2.model.UsageStatisticsFilter]] =
      Optional.Absent,
    maxResults: Optional[__integer] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    sortBy: Optional[zio.aws.macie2.model.UsageStatisticsSortBy] =
      Optional.Absent,
    timeRange: Optional[zio.aws.macie2.model.TimeRange] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest = {
    import GetUsageStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest
      .builder()
      .optionallyWith(
        filterBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterBy)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(timeRange.map(value => value.unwrap))(_.timeRange)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetUsageStatisticsRequest.ReadOnly =
    zio.aws.macie2.model.GetUsageStatisticsRequest.wrap(buildAwsValue())
}
object GetUsageStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetUsageStatisticsRequest =
      zio.aws.macie2.model.GetUsageStatisticsRequest(
        filterBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value.asEditable),
        timeRange.map(value => value)
      )
    def filterBy
        : Optional[List[zio.aws.macie2.model.UsageStatisticsFilter.ReadOnly]]
    def maxResults: Optional[__integer]
    def nextToken: Optional[__string]
    def sortBy: Optional[zio.aws.macie2.model.UsageStatisticsSortBy.ReadOnly]
    def timeRange: Optional[zio.aws.macie2.model.TimeRange]
    def getFilterBy: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.UsageStatisticsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filterBy", filterBy)
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.UsageStatisticsSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getTimeRange: ZIO[Any, AwsError, zio.aws.macie2.model.TimeRange] =
      AwsError.unwrapOptionField("timeRange", timeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest
  ) extends zio.aws.macie2.model.GetUsageStatisticsRequest.ReadOnly {
    override val filterBy
        : Optional[List[zio.aws.macie2.model.UsageStatisticsFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterBy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.UsageStatisticsFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: __integer)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val sortBy
        : Optional[zio.aws.macie2.model.UsageStatisticsSortBy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.macie2.model.UsageStatisticsSortBy.wrap(value))
    override val timeRange: Optional[zio.aws.macie2.model.TimeRange] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeRange())
        .map(value => zio.aws.macie2.model.TimeRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest
  ): zio.aws.macie2.model.GetUsageStatisticsRequest.ReadOnly = new Wrapper(impl)
}
