package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Cell(
    cellReference: Optional[__string] = Optional.Absent,
    column: Optional[__long] = Optional.Absent,
    columnName: Optional[__string] = Optional.Absent,
    row: Optional[__long] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.Cell = {
    import Cell.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Cell
      .builder()
      .optionallyWith(cellReference.map(value => value: java.lang.String))(
        _.cellReference
      )
      .optionallyWith(column.map(value => value: java.lang.Long))(_.column)
      .optionallyWith(columnName.map(value => value: java.lang.String))(
        _.columnName
      )
      .optionallyWith(row.map(value => value: java.lang.Long))(_.row)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Cell.ReadOnly =
    zio.aws.macie2.model.Cell.wrap(buildAwsValue())
}
object Cell {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Cell] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Cell = zio.aws.macie2.model.Cell(
      cellReference.map(value => value),
      column.map(value => value),
      columnName.map(value => value),
      row.map(value => value)
    )
    def cellReference: Optional[__string]
    def column: Optional[__long]
    def columnName: Optional[__string]
    def row: Optional[__long]
    def getCellReference: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("cellReference", cellReference)
    def getColumn: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("column", column)
    def getColumnName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("columnName", columnName)
    def getRow: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("row", row)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Cell
  ) extends zio.aws.macie2.model.Cell.ReadOnly {
    override val cellReference: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.cellReference())
      .map(value => value: __string)
    override val column: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.column())
      .map(value => value: __long)
    override val columnName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.columnName())
      .map(value => value: __string)
    override val row: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.row())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Cell
  ): zio.aws.macie2.model.Cell.ReadOnly = new Wrapper(impl)
}
