package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobScheduleFrequency(
    dailySchedule: Optional[zio.aws.macie2.model.DailySchedule] =
      Optional.Absent,
    monthlySchedule: Optional[zio.aws.macie2.model.MonthlySchedule] =
      Optional.Absent,
    weeklySchedule: Optional[zio.aws.macie2.model.WeeklySchedule] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.JobScheduleFrequency = {
    import JobScheduleFrequency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.JobScheduleFrequency
      .builder()
      .optionallyWith(dailySchedule.map(value => value.buildAwsValue()))(
        _.dailySchedule
      )
      .optionallyWith(monthlySchedule.map(value => value.buildAwsValue()))(
        _.monthlySchedule
      )
      .optionallyWith(weeklySchedule.map(value => value.buildAwsValue()))(
        _.weeklySchedule
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.JobScheduleFrequency.ReadOnly =
    zio.aws.macie2.model.JobScheduleFrequency.wrap(buildAwsValue())
}
object JobScheduleFrequency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.JobScheduleFrequency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.JobScheduleFrequency =
      zio.aws.macie2.model.JobScheduleFrequency(
        dailySchedule.map(value => value.asEditable),
        monthlySchedule.map(value => value.asEditable),
        weeklySchedule.map(value => value.asEditable)
      )
    def dailySchedule: Optional[zio.aws.macie2.model.DailySchedule.ReadOnly]
    def monthlySchedule: Optional[zio.aws.macie2.model.MonthlySchedule.ReadOnly]
    def weeklySchedule: Optional[zio.aws.macie2.model.WeeklySchedule.ReadOnly]
    def getDailySchedule
        : ZIO[Any, AwsError, zio.aws.macie2.model.DailySchedule.ReadOnly] =
      AwsError.unwrapOptionField("dailySchedule", dailySchedule)
    def getMonthlySchedule
        : ZIO[Any, AwsError, zio.aws.macie2.model.MonthlySchedule.ReadOnly] =
      AwsError.unwrapOptionField("monthlySchedule", monthlySchedule)
    def getWeeklySchedule
        : ZIO[Any, AwsError, zio.aws.macie2.model.WeeklySchedule.ReadOnly] =
      AwsError.unwrapOptionField("weeklySchedule", weeklySchedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.JobScheduleFrequency
  ) extends zio.aws.macie2.model.JobScheduleFrequency.ReadOnly {
    override val dailySchedule
        : Optional[zio.aws.macie2.model.DailySchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailySchedule())
        .map(value => zio.aws.macie2.model.DailySchedule.wrap(value))
    override val monthlySchedule
        : Optional[zio.aws.macie2.model.MonthlySchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monthlySchedule())
        .map(value => zio.aws.macie2.model.MonthlySchedule.wrap(value))
    override val weeklySchedule
        : Optional[zio.aws.macie2.model.WeeklySchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklySchedule())
        .map(value => zio.aws.macie2.model.WeeklySchedule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.JobScheduleFrequency
  ): zio.aws.macie2.model.JobScheduleFrequency.ReadOnly = new Wrapper(impl)
}
