package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{
  __timestampIso8601,
  __long,
  __boolean,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Finding(
    accountId: Optional[__string] = Optional.Absent,
    archived: Optional[__boolean] = Optional.Absent,
    category: Optional[zio.aws.macie2.model.FindingCategory] = Optional.Absent,
    classificationDetails: Optional[
      zio.aws.macie2.model.ClassificationDetails
    ] = Optional.Absent,
    count: Optional[__long] = Optional.Absent,
    createdAt: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    partition: Optional[__string] = Optional.Absent,
    policyDetails: Optional[zio.aws.macie2.model.PolicyDetails] =
      Optional.Absent,
    region: Optional[__string] = Optional.Absent,
    resourcesAffected: Optional[zio.aws.macie2.model.ResourcesAffected] =
      Optional.Absent,
    sample: Optional[__boolean] = Optional.Absent,
    schemaVersion: Optional[__string] = Optional.Absent,
    severity: Optional[zio.aws.macie2.model.Severity] = Optional.Absent,
    title: Optional[__string] = Optional.Absent,
    `type`: Optional[zio.aws.macie2.model.FindingType] = Optional.Absent,
    updatedAt: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.Finding = {
    import Finding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Finding
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(archived.map(value => value: java.lang.Boolean))(
        _.archived
      )
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(
        classificationDetails.map(value => value.buildAwsValue())
      )(_.classificationDetails)
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(partition.map(value => value: java.lang.String))(
        _.partition
      )
      .optionallyWith(policyDetails.map(value => value.buildAwsValue()))(
        _.policyDetails
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(resourcesAffected.map(value => value.buildAwsValue()))(
        _.resourcesAffected
      )
      .optionallyWith(sample.map(value => value: java.lang.Boolean))(_.sample)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(severity.map(value => value.buildAwsValue()))(_.severity)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(updatedAt.map(value => value: Instant))(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Finding.ReadOnly =
    zio.aws.macie2.model.Finding.wrap(buildAwsValue())
}
object Finding {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Finding] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Finding = zio.aws.macie2.model.Finding(
      accountId.map(value => value),
      archived.map(value => value),
      category.map(value => value),
      classificationDetails.map(value => value.asEditable),
      count.map(value => value),
      createdAt.map(value => value),
      description.map(value => value),
      id.map(value => value),
      partition.map(value => value),
      policyDetails.map(value => value.asEditable),
      region.map(value => value),
      resourcesAffected.map(value => value.asEditable),
      sample.map(value => value),
      schemaVersion.map(value => value),
      severity.map(value => value.asEditable),
      title.map(value => value),
      `type`.map(value => value),
      updatedAt.map(value => value)
    )
    def accountId: Optional[__string]
    def archived: Optional[__boolean]
    def category: Optional[zio.aws.macie2.model.FindingCategory]
    def classificationDetails
        : Optional[zio.aws.macie2.model.ClassificationDetails.ReadOnly]
    def count: Optional[__long]
    def createdAt: Optional[__timestampIso8601]
    def description: Optional[__string]
    def id: Optional[__string]
    def partition: Optional[__string]
    def policyDetails: Optional[zio.aws.macie2.model.PolicyDetails.ReadOnly]
    def region: Optional[__string]
    def resourcesAffected
        : Optional[zio.aws.macie2.model.ResourcesAffected.ReadOnly]
    def sample: Optional[__boolean]
    def schemaVersion: Optional[__string]
    def severity: Optional[zio.aws.macie2.model.Severity.ReadOnly]
    def title: Optional[__string]
    def `type`: Optional[zio.aws.macie2.model.FindingType]
    def updatedAt: Optional[__timestampIso8601]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getArchived: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("archived", archived)
    def getCategory: ZIO[Any, AwsError, zio.aws.macie2.model.FindingCategory] =
      AwsError.unwrapOptionField("category", category)
    def getClassificationDetails: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ClassificationDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("classificationDetails", classificationDetails)
    def getCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("count", count)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getPartition: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("partition", partition)
    def getPolicyDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.PolicyDetails.ReadOnly] =
      AwsError.unwrapOptionField("policyDetails", policyDetails)
    def getRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("region", region)
    def getResourcesAffected
        : ZIO[Any, AwsError, zio.aws.macie2.model.ResourcesAffected.ReadOnly] =
      AwsError.unwrapOptionField("resourcesAffected", resourcesAffected)
    def getSample: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("sample", sample)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.macie2.model.Severity.ReadOnly] =
      AwsError.unwrapOptionField("severity", severity)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getType: ZIO[Any, AwsError, zio.aws.macie2.model.FindingType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Finding
  ) extends zio.aws.macie2.model.Finding.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val archived: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.archived())
      .map(value => value: __boolean)
    override val category: Optional[zio.aws.macie2.model.FindingCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.category())
        .map(value => zio.aws.macie2.model.FindingCategory.wrap(value))
    override val classificationDetails
        : Optional[zio.aws.macie2.model.ClassificationDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classificationDetails())
        .map(value => zio.aws.macie2.model.ClassificationDetails.wrap(value))
    override val count: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: __long)
    override val createdAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __timestampIso8601)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val partition: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.partition())
      .map(value => value: __string)
    override val policyDetails
        : Optional[zio.aws.macie2.model.PolicyDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDetails())
        .map(value => zio.aws.macie2.model.PolicyDetails.wrap(value))
    override val region: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: __string)
    override val resourcesAffected
        : Optional[zio.aws.macie2.model.ResourcesAffected.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcesAffected())
        .map(value => zio.aws.macie2.model.ResourcesAffected.wrap(value))
    override val sample: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sample())
      .map(value => value: __boolean)
    override val schemaVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: __string)
    override val severity: Optional[zio.aws.macie2.model.Severity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.macie2.model.Severity.wrap(value))
    override val title: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: __string)
    override val `type`: Optional[zio.aws.macie2.model.FindingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.macie2.model.FindingType.wrap(value))
    override val updatedAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Finding
  ): zio.aws.macie2.model.Finding.ReadOnly = new Wrapper(impl)
}
