package zio.aws.macie2
import software.amazon.awssdk.services.macie2.{
  Macie2AsyncClientBuilder,
  Macie2AsyncClient
}
import zio.aws.macie2.model.UpdateClassificationJobResponse.ReadOnly
import zio.aws.macie2.model.{
  GetBucketStatisticsRequest,
  EnableOrganizationAdminAccountRequest,
  UpdateFindingsFilterRequest,
  GetFindingsPublicationConfigurationRequest,
  TestCustomDataIdentifierRequest,
  SearchResourcesRequest,
  DisableOrganizationAdminAccountRequest,
  CreateClassificationJobRequest,
  CreateMemberRequest,
  CreateInvitationsRequest,
  DeleteInvitationsRequest,
  CreateSampleFindingsRequest,
  DisableMacieRequest,
  CreateFindingsFilterRequest,
  DisassociateFromMasterAccountRequest,
  GetMacieSessionRequest,
  EnableMacieRequest,
  ListMembersRequest,
  UpdateRevealConfigurationRequest,
  GetRevealConfigurationRequest,
  ListClassificationJobsRequest,
  PutClassificationExportConfigurationRequest,
  GetClassificationExportConfigurationRequest,
  ListTagsForResourceRequest,
  CreateCustomDataIdentifierRequest,
  GetFindingsRequest,
  PutFindingsPublicationConfigurationRequest,
  DeleteCustomDataIdentifierRequest,
  GetSensitiveDataOccurrencesAvailabilityRequest,
  DescribeClassificationJobRequest,
  GetAdministratorAccountRequest,
  DeclineInvitationsRequest,
  ListOrganizationAdminAccountsRequest,
  GetMemberRequest,
  ListFindingsRequest,
  UpdateOrganizationConfigurationRequest,
  ListInvitationsRequest,
  GetFindingStatisticsRequest,
  DeleteFindingsFilterRequest,
  BatchGetCustomDataIdentifiersRequest,
  DeleteMemberRequest,
  UntagResourceRequest,
  ListManagedDataIdentifiersRequest,
  UpdateMemberSessionRequest,
  GetFindingsFilterRequest,
  AcceptInvitationRequest,
  GetUsageStatisticsRequest,
  UpdateMacieSessionRequest,
  ListCustomDataIdentifiersRequest,
  DescribeBucketsRequest,
  DisassociateMemberRequest,
  UpdateClassificationJobRequest,
  DescribeOrganizationConfigurationRequest,
  GetInvitationsCountRequest,
  ListFindingsFiltersRequest,
  GetCustomDataIdentifierRequest,
  GetMasterAccountRequest,
  DisassociateFromAdministratorAccountRequest,
  TagResourceRequest,
  GetSensitiveDataOccurrencesRequest,
  GetUsageTotalsRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.macie2.model.{
  AdminAccount,
  GetMasterAccountResponse,
  GetCustomDataIdentifierResponse,
  Invitation,
  GetSensitiveDataOccurrencesResponse,
  DeclineInvitationsResponse,
  GetUsageStatisticsResponse,
  GetMacieSessionResponse,
  ListOrganizationAdminAccountsResponse,
  ListMembersResponse,
  MatchingResource,
  CreateMemberResponse,
  DisableMacieResponse,
  GetClassificationExportConfigurationResponse,
  GetFindingStatisticsResponse,
  DescribeOrganizationConfigurationResponse,
  GetRevealConfigurationResponse,
  DeleteInvitationsResponse,
  GetFindingsResponse,
  ListClassificationJobsResponse,
  GetUsageTotalsResponse,
  DeleteCustomDataIdentifierResponse,
  CreateFindingsFilterResponse,
  DisableOrganizationAdminAccountResponse,
  ListTagsForResourceResponse,
  ListFindingsResponse,
  UntagResourceResponse,
  GetSensitiveDataOccurrencesAvailabilityResponse,
  DeleteMemberResponse,
  SearchResourcesResponse,
  AcceptInvitationResponse,
  ListFindingsFiltersResponse,
  UsageRecord,
  GetAdministratorAccountResponse,
  UpdateOrganizationConfigurationResponse,
  ListManagedDataIdentifiersResponse,
  GetBucketStatisticsResponse,
  GetFindingsFilterResponse,
  ListCustomDataIdentifiersResponse,
  DeleteFindingsFilterResponse,
  ListInvitationsResponse,
  PutFindingsPublicationConfigurationResponse,
  CreateInvitationsResponse,
  BucketMetadata,
  UpdateFindingsFilterResponse,
  CreateCustomDataIdentifierResponse,
  UpdateClassificationJobResponse,
  CreateClassificationJobResponse,
  EnableOrganizationAdminAccountResponse,
  DescribeClassificationJobResponse,
  UpdateRevealConfigurationResponse,
  DescribeBucketsResponse,
  DisassociateFromMasterAccountResponse,
  PutClassificationExportConfigurationResponse,
  GetInvitationsCountResponse,
  BatchGetCustomDataIdentifiersResponse,
  CreateSampleFindingsResponse,
  GetFindingsPublicationConfigurationResponse,
  TagResourceResponse,
  UpdateMemberSessionResponse,
  GetMemberResponse,
  DisassociateFromAdministratorAccountResponse,
  EnableMacieResponse,
  Member,
  CustomDataIdentifierSummary,
  JobSummary,
  FindingsFilterListItem,
  DisassociateMemberResponse,
  UpdateMacieSessionResponse,
  TestCustomDataIdentifierResponse
}
import zio.aws.macie2.model.primitives.__string
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.macie2.paginators.{
  SearchResourcesPublisher,
  GetUsageStatisticsPublisher,
  ListMembersPublisher,
  ListCustomDataIdentifiersPublisher,
  ListOrganizationAdminAccountsPublisher,
  ListFindingsPublisher,
  ListClassificationJobsPublisher,
  ListFindingsFiltersPublisher,
  DescribeBucketsPublisher,
  ListInvitationsPublisher
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Macie2 extends AspectSupport[Macie2] {
  val api: Macie2AsyncClient
  def getAdministratorAccount(
      request: GetAdministratorAccountRequest
  ): IO[AwsError, zio.aws.macie2.model.GetAdministratorAccountResponse.ReadOnly]
  def listFindings(
      request: ListFindingsRequest
  ): ZStream[Any, AwsError, __string]
  def listFindingsPaginated(
      request: ListFindingsRequest
  ): IO[AwsError, zio.aws.macie2.model.ListFindingsResponse.ReadOnly]
  def listClassificationJobs(
      request: ListClassificationJobsRequest
  ): ZStream[Any, AwsError, zio.aws.macie2.model.JobSummary.ReadOnly]
  def listClassificationJobsPaginated(
      request: ListClassificationJobsRequest
  ): IO[AwsError, zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly]
  def disableOrganizationAdminAccount(
      request: DisableOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.DisableOrganizationAdminAccountResponse.ReadOnly
  ]
  def createSampleFindings(
      request: CreateSampleFindingsRequest
  ): IO[AwsError, zio.aws.macie2.model.CreateSampleFindingsResponse.ReadOnly]
  def getMacieSession(
      request: GetMacieSessionRequest
  ): IO[AwsError, zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly]
  def createClassificationJob(
      request: CreateClassificationJobRequest
  ): IO[AwsError, zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly]
  def listOrganizationAdminAccounts(
      request: ListOrganizationAdminAccountsRequest
  ): ZStream[Any, AwsError, zio.aws.macie2.model.AdminAccount.ReadOnly]
  def listOrganizationAdminAccountsPaginated(
      request: ListOrganizationAdminAccountsRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly
  ]
  def updateOrganizationConfiguration(
      request: UpdateOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.UpdateOrganizationConfigurationResponse.ReadOnly
  ]
  def updateFindingsFilter(
      request: UpdateFindingsFilterRequest
  ): IO[AwsError, zio.aws.macie2.model.UpdateFindingsFilterResponse.ReadOnly]
  def createMember(
      request: CreateMemberRequest
  ): IO[AwsError, zio.aws.macie2.model.CreateMemberResponse.ReadOnly]
  def putFindingsPublicationConfiguration(
      request: PutFindingsPublicationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.PutFindingsPublicationConfigurationResponse.ReadOnly
  ]
  def createInvitations(
      request: CreateInvitationsRequest
  ): IO[AwsError, zio.aws.macie2.model.CreateInvitationsResponse.ReadOnly]
  def disassociateMember(
      request: DisassociateMemberRequest
  ): IO[AwsError, zio.aws.macie2.model.DisassociateMemberResponse.ReadOnly]
  def listFindingsFilters(request: ListFindingsFiltersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.macie2.model.FindingsFilterListItem.ReadOnly
  ]
  def listFindingsFiltersPaginated(
      request: ListFindingsFiltersRequest
  ): IO[AwsError, zio.aws.macie2.model.ListFindingsFiltersResponse.ReadOnly]
  def getInvitationsCount(
      request: GetInvitationsCountRequest
  ): IO[AwsError, zio.aws.macie2.model.GetInvitationsCountResponse.ReadOnly]
  def createCustomDataIdentifier(
      request: CreateCustomDataIdentifierRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.CreateCustomDataIdentifierResponse.ReadOnly
  ]
  def updateMacieSession(
      request: UpdateMacieSessionRequest
  ): IO[AwsError, zio.aws.macie2.model.UpdateMacieSessionResponse.ReadOnly]
  def disassociateFromMasterAccount(
      request: DisassociateFromMasterAccountRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.DisassociateFromMasterAccountResponse.ReadOnly
  ]
  def putClassificationExportConfiguration(
      request: PutClassificationExportConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.PutClassificationExportConfigurationResponse.ReadOnly
  ]
  def listMembers(
      request: ListMembersRequest
  ): ZStream[Any, AwsError, zio.aws.macie2.model.Member.ReadOnly]
  def listMembersPaginated(
      request: ListMembersRequest
  ): IO[AwsError, zio.aws.macie2.model.ListMembersResponse.ReadOnly]
  def listManagedDataIdentifiers(
      request: ListManagedDataIdentifiersRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.ListManagedDataIdentifiersResponse.ReadOnly
  ]
  def describeBuckets(
      request: DescribeBucketsRequest
  ): ZStream[Any, AwsError, zio.aws.macie2.model.BucketMetadata.ReadOnly]
  def describeBucketsPaginated(
      request: DescribeBucketsRequest
  ): IO[AwsError, zio.aws.macie2.model.DescribeBucketsResponse.ReadOnly]
  def enableMacie(
      request: EnableMacieRequest
  ): IO[AwsError, zio.aws.macie2.model.EnableMacieResponse.ReadOnly]
  def getSensitiveDataOccurrencesAvailability(
      request: GetSensitiveDataOccurrencesAvailabilityRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse.ReadOnly
  ]
  def getFindingStatistics(
      request: GetFindingStatisticsRequest
  ): IO[AwsError, zio.aws.macie2.model.GetFindingStatisticsResponse.ReadOnly]
  def getRevealConfiguration(
      request: GetRevealConfigurationRequest
  ): IO[AwsError, zio.aws.macie2.model.GetRevealConfigurationResponse.ReadOnly]
  def searchResources(
      request: SearchResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.macie2.model.MatchingResource.ReadOnly]
  def searchResourcesPaginated(
      request: SearchResourcesRequest
  ): IO[AwsError, zio.aws.macie2.model.SearchResourcesResponse.ReadOnly]
  def disableMacie(
      request: DisableMacieRequest
  ): IO[AwsError, zio.aws.macie2.model.DisableMacieResponse.ReadOnly]
  def getSensitiveDataOccurrences(
      request: GetSensitiveDataOccurrencesRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.macie2.model.UntagResourceResponse.ReadOnly]
  def getFindings(
      request: GetFindingsRequest
  ): IO[AwsError, zio.aws.macie2.model.GetFindingsResponse.ReadOnly]
  def getMember(
      request: GetMemberRequest
  ): IO[AwsError, zio.aws.macie2.model.GetMemberResponse.ReadOnly]
  def getCustomDataIdentifier(
      request: GetCustomDataIdentifierRequest
  ): IO[AwsError, zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly]
  def describeOrganizationConfiguration(
      request: DescribeOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ]
  def acceptInvitation(
      request: AcceptInvitationRequest
  ): IO[AwsError, zio.aws.macie2.model.AcceptInvitationResponse.ReadOnly]
  def deleteMember(
      request: DeleteMemberRequest
  ): IO[AwsError, zio.aws.macie2.model.DeleteMemberResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.macie2.model.ListTagsForResourceResponse.ReadOnly]
  def getFindingsPublicationConfiguration(
      request: GetFindingsPublicationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse.ReadOnly
  ]
  def getClassificationExportConfiguration(
      request: GetClassificationExportConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.GetClassificationExportConfigurationResponse.ReadOnly
  ]
  def describeClassificationJob(request: DescribeClassificationJobRequest): IO[
    AwsError,
    zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.macie2.model.TagResourceResponse.ReadOnly]
  def listInvitations(
      request: ListInvitationsRequest
  ): ZStream[Any, AwsError, zio.aws.macie2.model.Invitation.ReadOnly]
  def listInvitationsPaginated(
      request: ListInvitationsRequest
  ): IO[AwsError, zio.aws.macie2.model.ListInvitationsResponse.ReadOnly]
  def batchGetCustomDataIdentifiers(
      request: BatchGetCustomDataIdentifiersRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse.ReadOnly
  ]
  def deleteFindingsFilter(
      request: DeleteFindingsFilterRequest
  ): IO[AwsError, zio.aws.macie2.model.DeleteFindingsFilterResponse.ReadOnly]
  def getFindingsFilter(
      request: GetFindingsFilterRequest
  ): IO[AwsError, zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly]
  def declineInvitations(
      request: DeclineInvitationsRequest
  ): IO[AwsError, zio.aws.macie2.model.DeclineInvitationsResponse.ReadOnly]
  def getUsageTotals(
      request: GetUsageTotalsRequest
  ): IO[AwsError, zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly]
  def getBucketStatistics(
      request: GetBucketStatisticsRequest
  ): IO[AwsError, zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly]
  def createFindingsFilter(
      request: CreateFindingsFilterRequest
  ): IO[AwsError, zio.aws.macie2.model.CreateFindingsFilterResponse.ReadOnly]
  def enableOrganizationAdminAccount(
      request: EnableOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.EnableOrganizationAdminAccountResponse.ReadOnly
  ]
  def getMasterAccount(
      request: GetMasterAccountRequest
  ): IO[AwsError, zio.aws.macie2.model.GetMasterAccountResponse.ReadOnly]
  def listCustomDataIdentifiers(
      request: ListCustomDataIdentifiersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly
  ]
  def listCustomDataIdentifiersPaginated(
      request: ListCustomDataIdentifiersRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.ListCustomDataIdentifiersResponse.ReadOnly
  ]
  def deleteInvitations(
      request: DeleteInvitationsRequest
  ): IO[AwsError, zio.aws.macie2.model.DeleteInvitationsResponse.ReadOnly]
  def updateClassificationJob(
      request: UpdateClassificationJobRequest
  ): IO[AwsError, ReadOnly]
  def testCustomDataIdentifier(request: TestCustomDataIdentifierRequest): IO[
    AwsError,
    zio.aws.macie2.model.TestCustomDataIdentifierResponse.ReadOnly
  ]
  def updateRevealConfiguration(request: UpdateRevealConfigurationRequest): IO[
    AwsError,
    zio.aws.macie2.model.UpdateRevealConfigurationResponse.ReadOnly
  ]
  def deleteCustomDataIdentifier(
      request: DeleteCustomDataIdentifierRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.DeleteCustomDataIdentifierResponse.ReadOnly
  ]
  def disassociateFromAdministratorAccount(
      request: DisassociateFromAdministratorAccountRequest
  ): IO[
    AwsError,
    zio.aws.macie2.model.DisassociateFromAdministratorAccountResponse.ReadOnly
  ]
  def getUsageStatistics(
      request: GetUsageStatisticsRequest
  ): ZStream[Any, AwsError, zio.aws.macie2.model.UsageRecord.ReadOnly]
  def getUsageStatisticsPaginated(
      request: GetUsageStatisticsRequest
  ): IO[AwsError, zio.aws.macie2.model.GetUsageStatisticsResponse.ReadOnly]
  def updateMemberSession(
      request: UpdateMemberSessionRequest
  ): IO[AwsError, zio.aws.macie2.model.UpdateMemberSessionResponse.ReadOnly]
}
object Macie2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Macie2] = customized(
    identity
  )
  def customized(
      customization: Macie2AsyncClientBuilder => Macie2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Macie2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: Macie2AsyncClientBuilder => Macie2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Macie2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = Macie2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[Macie2AsyncClient, Macie2AsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[Macie2AsyncClient, Macie2AsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new Macie2Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class Macie2Impl[R](
      override val api: Macie2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Macie2
      with AwsServiceBase[R] {
    override val serviceName: String = "Macie2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Macie2Impl[R1] = new Macie2Impl(api, newAspect, r)
    def getAdministratorAccount(request: GetAdministratorAccountRequest): IO[
      AwsError,
      zio.aws.macie2.model.GetAdministratorAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.GetAdministratorAccountRequest,
      GetAdministratorAccountResponse
    ]("getAdministratorAccount", api.getAdministratorAccount)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.GetAdministratorAccountResponse.wrap)
      .provideEnvironment(r)
    def listFindings(
        request: ListFindingsRequest
    ): ZStream[Any, AwsError, __string] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.macie2.model.ListFindingsRequest,
      java.lang.String,
      ListFindingsPublisher
    ]("listFindings", api.listFindingsPaginator, _.findingIds())(
      request.buildAwsValue()
    ).map(item => item: __string).provideEnvironment(r)
    def listFindingsPaginated(
        request: ListFindingsRequest
    ): IO[AwsError, zio.aws.macie2.model.ListFindingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.ListFindingsRequest,
        ListFindingsResponse
      ]("listFindings", api.listFindings)(request.buildAwsValue())
        .map(zio.aws.macie2.model.ListFindingsResponse.wrap)
        .provideEnvironment(r)
    def listClassificationJobs(request: ListClassificationJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.macie2.model.JobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest,
      JobSummary,
      ListClassificationJobsPublisher
    ]("listClassificationJobs", api.listClassificationJobsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.macie2.model.JobSummary.wrap(item))
      .provideEnvironment(r)
    def listClassificationJobsPaginated(
        request: ListClassificationJobsRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest,
      ListClassificationJobsResponse
    ]("listClassificationJobs", api.listClassificationJobs)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.ListClassificationJobsResponse.wrap)
      .provideEnvironment(r)
    def disableOrganizationAdminAccount(
        request: DisableOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.DisableOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.DisableOrganizationAdminAccountRequest,
      DisableOrganizationAdminAccountResponse
    ]("disableOrganizationAdminAccount", api.disableOrganizationAdminAccount)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.DisableOrganizationAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def createSampleFindings(request: CreateSampleFindingsRequest): IO[
      AwsError,
      zio.aws.macie2.model.CreateSampleFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest,
      CreateSampleFindingsResponse
    ]("createSampleFindings", api.createSampleFindings)(request.buildAwsValue())
      .map(zio.aws.macie2.model.CreateSampleFindingsResponse.wrap)
      .provideEnvironment(r)
    def getMacieSession(
        request: GetMacieSessionRequest
    ): IO[AwsError, zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.GetMacieSessionRequest,
        GetMacieSessionResponse
      ]("getMacieSession", api.getMacieSession)(request.buildAwsValue())
        .map(zio.aws.macie2.model.GetMacieSessionResponse.wrap)
        .provideEnvironment(r)
    def createClassificationJob(request: CreateClassificationJobRequest): IO[
      AwsError,
      zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest,
      CreateClassificationJobResponse
    ]("createClassificationJob", api.createClassificationJob)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.CreateClassificationJobResponse.wrap)
      .provideEnvironment(r)
    def listOrganizationAdminAccounts(
        request: ListOrganizationAdminAccountsRequest
    ): ZStream[Any, AwsError, zio.aws.macie2.model.AdminAccount.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest,
        AdminAccount,
        ListOrganizationAdminAccountsPublisher
      ](
        "listOrganizationAdminAccounts",
        api.listOrganizationAdminAccountsPaginator,
        _.adminAccounts()
      )(request.buildAwsValue())
        .map(item => zio.aws.macie2.model.AdminAccount.wrap(item))
        .provideEnvironment(r)
    def listOrganizationAdminAccountsPaginated(
        request: ListOrganizationAdminAccountsRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest,
      ListOrganizationAdminAccountsResponse
    ]("listOrganizationAdminAccounts", api.listOrganizationAdminAccounts)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.wrap)
      .provideEnvironment(r)
    def updateOrganizationConfiguration(
        request: UpdateOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.UpdateOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.UpdateOrganizationConfigurationRequest,
      UpdateOrganizationConfigurationResponse
    ]("updateOrganizationConfiguration", api.updateOrganizationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.UpdateOrganizationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateFindingsFilter(request: UpdateFindingsFilterRequest): IO[
      AwsError,
      zio.aws.macie2.model.UpdateFindingsFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest,
      UpdateFindingsFilterResponse
    ]("updateFindingsFilter", api.updateFindingsFilter)(request.buildAwsValue())
      .map(zio.aws.macie2.model.UpdateFindingsFilterResponse.wrap)
      .provideEnvironment(r)
    def createMember(
        request: CreateMemberRequest
    ): IO[AwsError, zio.aws.macie2.model.CreateMemberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.CreateMemberRequest,
        CreateMemberResponse
      ]("createMember", api.createMember)(request.buildAwsValue())
        .map(zio.aws.macie2.model.CreateMemberResponse.wrap)
        .provideEnvironment(r)
    def putFindingsPublicationConfiguration(
        request: PutFindingsPublicationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.PutFindingsPublicationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationRequest,
      PutFindingsPublicationConfigurationResponse
    ](
      "putFindingsPublicationConfiguration",
      api.putFindingsPublicationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.macie2.model.PutFindingsPublicationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def createInvitations(
        request: CreateInvitationsRequest
    ): IO[AwsError, zio.aws.macie2.model.CreateInvitationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest,
        CreateInvitationsResponse
      ]("createInvitations", api.createInvitations)(request.buildAwsValue())
        .map(zio.aws.macie2.model.CreateInvitationsResponse.wrap)
        .provideEnvironment(r)
    def disassociateMember(
        request: DisassociateMemberRequest
    ): IO[AwsError, zio.aws.macie2.model.DisassociateMemberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.DisassociateMemberRequest,
        DisassociateMemberResponse
      ]("disassociateMember", api.disassociateMember)(request.buildAwsValue())
        .map(zio.aws.macie2.model.DisassociateMemberResponse.wrap)
        .provideEnvironment(r)
    def listFindingsFilters(request: ListFindingsFiltersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.macie2.model.FindingsFilterListItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest,
      FindingsFilterListItem,
      ListFindingsFiltersPublisher
    ](
      "listFindingsFilters",
      api.listFindingsFiltersPaginator,
      _.findingsFilterListItems()
    )(request.buildAwsValue())
      .map(item => zio.aws.macie2.model.FindingsFilterListItem.wrap(item))
      .provideEnvironment(r)
    def listFindingsFiltersPaginated(
        request: ListFindingsFiltersRequest
    ): IO[AwsError, zio.aws.macie2.model.ListFindingsFiltersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest,
        ListFindingsFiltersResponse
      ]("listFindingsFilters", api.listFindingsFilters)(request.buildAwsValue())
        .map(zio.aws.macie2.model.ListFindingsFiltersResponse.wrap)
        .provideEnvironment(r)
    def getInvitationsCount(
        request: GetInvitationsCountRequest
    ): IO[AwsError, zio.aws.macie2.model.GetInvitationsCountResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.GetInvitationsCountRequest,
        GetInvitationsCountResponse
      ]("getInvitationsCount", api.getInvitationsCount)(request.buildAwsValue())
        .map(zio.aws.macie2.model.GetInvitationsCountResponse.wrap)
        .provideEnvironment(r)
    def createCustomDataIdentifier(
        request: CreateCustomDataIdentifierRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.CreateCustomDataIdentifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest,
      CreateCustomDataIdentifierResponse
    ]("createCustomDataIdentifier", api.createCustomDataIdentifier)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.CreateCustomDataIdentifierResponse.wrap)
      .provideEnvironment(r)
    def updateMacieSession(
        request: UpdateMacieSessionRequest
    ): IO[AwsError, zio.aws.macie2.model.UpdateMacieSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest,
        UpdateMacieSessionResponse
      ]("updateMacieSession", api.updateMacieSession)(request.buildAwsValue())
        .map(zio.aws.macie2.model.UpdateMacieSessionResponse.wrap)
        .provideEnvironment(r)
    def disassociateFromMasterAccount(
        request: DisassociateFromMasterAccountRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.DisassociateFromMasterAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.DisassociateFromMasterAccountRequest,
      DisassociateFromMasterAccountResponse
    ]("disassociateFromMasterAccount", api.disassociateFromMasterAccount)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.DisassociateFromMasterAccountResponse.wrap)
      .provideEnvironment(r)
    def putClassificationExportConfiguration(
        request: PutClassificationExportConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.PutClassificationExportConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest,
      PutClassificationExportConfigurationResponse
    ](
      "putClassificationExportConfiguration",
      api.putClassificationExportConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.macie2.model.PutClassificationExportConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listMembers(
        request: ListMembersRequest
    ): ZStream[Any, AwsError, zio.aws.macie2.model.Member.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.macie2.model.ListMembersRequest,
        Member,
        ListMembersPublisher
      ]("listMembers", api.listMembersPaginator, _.members())(
        request.buildAwsValue()
      ).map(item => zio.aws.macie2.model.Member.wrap(item))
        .provideEnvironment(r)
    def listMembersPaginated(
        request: ListMembersRequest
    ): IO[AwsError, zio.aws.macie2.model.ListMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.ListMembersRequest,
        ListMembersResponse
      ]("listMembers", api.listMembers)(request.buildAwsValue())
        .map(zio.aws.macie2.model.ListMembersResponse.wrap)
        .provideEnvironment(r)
    def listManagedDataIdentifiers(
        request: ListManagedDataIdentifiersRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.ListManagedDataIdentifiersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest,
      ListManagedDataIdentifiersResponse
    ]("listManagedDataIdentifiers", api.listManagedDataIdentifiers)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.ListManagedDataIdentifiersResponse.wrap)
      .provideEnvironment(r)
    def describeBuckets(
        request: DescribeBucketsRequest
    ): ZStream[Any, AwsError, zio.aws.macie2.model.BucketMetadata.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest,
        BucketMetadata,
        DescribeBucketsPublisher
      ]("describeBuckets", api.describeBucketsPaginator, _.buckets())(
        request.buildAwsValue()
      ).map(item => zio.aws.macie2.model.BucketMetadata.wrap(item))
        .provideEnvironment(r)
    def describeBucketsPaginated(
        request: DescribeBucketsRequest
    ): IO[AwsError, zio.aws.macie2.model.DescribeBucketsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest,
        DescribeBucketsResponse
      ]("describeBuckets", api.describeBuckets)(request.buildAwsValue())
        .map(zio.aws.macie2.model.DescribeBucketsResponse.wrap)
        .provideEnvironment(r)
    def enableMacie(
        request: EnableMacieRequest
    ): IO[AwsError, zio.aws.macie2.model.EnableMacieResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.EnableMacieRequest,
        EnableMacieResponse
      ]("enableMacie", api.enableMacie)(request.buildAwsValue())
        .map(zio.aws.macie2.model.EnableMacieResponse.wrap)
        .provideEnvironment(r)
    def getSensitiveDataOccurrencesAvailability(
        request: GetSensitiveDataOccurrencesAvailabilityRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityRequest,
      GetSensitiveDataOccurrencesAvailabilityResponse
    ](
      "getSensitiveDataOccurrencesAvailability",
      api.getSensitiveDataOccurrencesAvailability
    )(request.buildAwsValue())
      .map(
        zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse.wrap
      )
      .provideEnvironment(r)
    def getFindingStatistics(request: GetFindingStatisticsRequest): IO[
      AwsError,
      zio.aws.macie2.model.GetFindingStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest,
      GetFindingStatisticsResponse
    ]("getFindingStatistics", api.getFindingStatistics)(request.buildAwsValue())
      .map(zio.aws.macie2.model.GetFindingStatisticsResponse.wrap)
      .provideEnvironment(r)
    def getRevealConfiguration(request: GetRevealConfigurationRequest): IO[
      AwsError,
      zio.aws.macie2.model.GetRevealConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.GetRevealConfigurationRequest,
      GetRevealConfigurationResponse
    ]("getRevealConfiguration", api.getRevealConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.GetRevealConfigurationResponse.wrap)
      .provideEnvironment(r)
    def searchResources(
        request: SearchResourcesRequest
    ): ZStream[Any, AwsError, zio.aws.macie2.model.MatchingResource.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.macie2.model.SearchResourcesRequest,
        MatchingResource,
        SearchResourcesPublisher
      ]("searchResources", api.searchResourcesPaginator, _.matchingResources())(
        request.buildAwsValue()
      ).map(item => zio.aws.macie2.model.MatchingResource.wrap(item))
        .provideEnvironment(r)
    def searchResourcesPaginated(
        request: SearchResourcesRequest
    ): IO[AwsError, zio.aws.macie2.model.SearchResourcesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.SearchResourcesRequest,
        SearchResourcesResponse
      ]("searchResources", api.searchResources)(request.buildAwsValue())
        .map(zio.aws.macie2.model.SearchResourcesResponse.wrap)
        .provideEnvironment(r)
    def disableMacie(
        request: DisableMacieRequest
    ): IO[AwsError, zio.aws.macie2.model.DisableMacieResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.DisableMacieRequest,
        DisableMacieResponse
      ]("disableMacie", api.disableMacie)(request.buildAwsValue())
        .map(zio.aws.macie2.model.DisableMacieResponse.wrap)
        .provideEnvironment(r)
    def getSensitiveDataOccurrences(
        request: GetSensitiveDataOccurrencesRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesRequest,
      GetSensitiveDataOccurrencesResponse
    ]("getSensitiveDataOccurrences", api.getSensitiveDataOccurrences)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.macie2.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.macie2.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getFindings(
        request: GetFindingsRequest
    ): IO[AwsError, zio.aws.macie2.model.GetFindingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.GetFindingsRequest,
        GetFindingsResponse
      ]("getFindings", api.getFindings)(request.buildAwsValue())
        .map(zio.aws.macie2.model.GetFindingsResponse.wrap)
        .provideEnvironment(r)
    def getMember(
        request: GetMemberRequest
    ): IO[AwsError, zio.aws.macie2.model.GetMemberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.GetMemberRequest,
        GetMemberResponse
      ]("getMember", api.getMember)(request.buildAwsValue())
        .map(zio.aws.macie2.model.GetMemberResponse.wrap)
        .provideEnvironment(r)
    def getCustomDataIdentifier(request: GetCustomDataIdentifierRequest): IO[
      AwsError,
      zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierRequest,
      GetCustomDataIdentifierResponse
    ]("getCustomDataIdentifier", api.getCustomDataIdentifier)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.GetCustomDataIdentifierResponse.wrap)
      .provideEnvironment(r)
    def describeOrganizationConfiguration(
        request: DescribeOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.DescribeOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationRequest,
      DescribeOrganizationConfigurationResponse
    ](
      "describeOrganizationConfiguration",
      api.describeOrganizationConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.macie2.model.DescribeOrganizationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def acceptInvitation(
        request: AcceptInvitationRequest
    ): IO[AwsError, zio.aws.macie2.model.AcceptInvitationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest,
        AcceptInvitationResponse
      ]("acceptInvitation", api.acceptInvitation)(request.buildAwsValue())
        .map(zio.aws.macie2.model.AcceptInvitationResponse.wrap)
        .provideEnvironment(r)
    def deleteMember(
        request: DeleteMemberRequest
    ): IO[AwsError, zio.aws.macie2.model.DeleteMemberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.DeleteMemberRequest,
        DeleteMemberResponse
      ]("deleteMember", api.deleteMember)(request.buildAwsValue())
        .map(zio.aws.macie2.model.DeleteMemberResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.macie2.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.macie2.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def getFindingsPublicationConfiguration(
        request: GetFindingsPublicationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationRequest,
      GetFindingsPublicationConfigurationResponse
    ](
      "getFindingsPublicationConfiguration",
      api.getFindingsPublicationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getClassificationExportConfiguration(
        request: GetClassificationExportConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.GetClassificationExportConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationRequest,
      GetClassificationExportConfigurationResponse
    ](
      "getClassificationExportConfiguration",
      api.getClassificationExportConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.macie2.model.GetClassificationExportConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def describeClassificationJob(
        request: DescribeClassificationJobRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.DescribeClassificationJobRequest,
      DescribeClassificationJobResponse
    ]("describeClassificationJob", api.describeClassificationJob)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.DescribeClassificationJobResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.macie2.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.macie2.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listInvitations(
        request: ListInvitationsRequest
    ): ZStream[Any, AwsError, zio.aws.macie2.model.Invitation.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.macie2.model.ListInvitationsRequest,
        Invitation,
        ListInvitationsPublisher
      ]("listInvitations", api.listInvitationsPaginator, _.invitations())(
        request.buildAwsValue()
      ).map(item => zio.aws.macie2.model.Invitation.wrap(item))
        .provideEnvironment(r)
    def listInvitationsPaginated(
        request: ListInvitationsRequest
    ): IO[AwsError, zio.aws.macie2.model.ListInvitationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.ListInvitationsRequest,
        ListInvitationsResponse
      ]("listInvitations", api.listInvitations)(request.buildAwsValue())
        .map(zio.aws.macie2.model.ListInvitationsResponse.wrap)
        .provideEnvironment(r)
    def batchGetCustomDataIdentifiers(
        request: BatchGetCustomDataIdentifiersRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest,
      BatchGetCustomDataIdentifiersResponse
    ]("batchGetCustomDataIdentifiers", api.batchGetCustomDataIdentifiers)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse.wrap)
      .provideEnvironment(r)
    def deleteFindingsFilter(request: DeleteFindingsFilterRequest): IO[
      AwsError,
      zio.aws.macie2.model.DeleteFindingsFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.DeleteFindingsFilterRequest,
      DeleteFindingsFilterResponse
    ]("deleteFindingsFilter", api.deleteFindingsFilter)(request.buildAwsValue())
      .map(zio.aws.macie2.model.DeleteFindingsFilterResponse.wrap)
      .provideEnvironment(r)
    def getFindingsFilter(
        request: GetFindingsFilterRequest
    ): IO[AwsError, zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.GetFindingsFilterRequest,
        GetFindingsFilterResponse
      ]("getFindingsFilter", api.getFindingsFilter)(request.buildAwsValue())
        .map(zio.aws.macie2.model.GetFindingsFilterResponse.wrap)
        .provideEnvironment(r)
    def declineInvitations(
        request: DeclineInvitationsRequest
    ): IO[AwsError, zio.aws.macie2.model.DeclineInvitationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.DeclineInvitationsRequest,
        DeclineInvitationsResponse
      ]("declineInvitations", api.declineInvitations)(request.buildAwsValue())
        .map(zio.aws.macie2.model.DeclineInvitationsResponse.wrap)
        .provideEnvironment(r)
    def getUsageTotals(
        request: GetUsageTotalsRequest
    ): IO[AwsError, zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest,
        GetUsageTotalsResponse
      ]("getUsageTotals", api.getUsageTotals)(request.buildAwsValue())
        .map(zio.aws.macie2.model.GetUsageTotalsResponse.wrap)
        .provideEnvironment(r)
    def getBucketStatistics(
        request: GetBucketStatisticsRequest
    ): IO[AwsError, zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest,
        GetBucketStatisticsResponse
      ]("getBucketStatistics", api.getBucketStatistics)(request.buildAwsValue())
        .map(zio.aws.macie2.model.GetBucketStatisticsResponse.wrap)
        .provideEnvironment(r)
    def createFindingsFilter(request: CreateFindingsFilterRequest): IO[
      AwsError,
      zio.aws.macie2.model.CreateFindingsFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest,
      CreateFindingsFilterResponse
    ]("createFindingsFilter", api.createFindingsFilter)(request.buildAwsValue())
      .map(zio.aws.macie2.model.CreateFindingsFilterResponse.wrap)
      .provideEnvironment(r)
    def enableOrganizationAdminAccount(
        request: EnableOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.EnableOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest,
      EnableOrganizationAdminAccountResponse
    ]("enableOrganizationAdminAccount", api.enableOrganizationAdminAccount)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.EnableOrganizationAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def getMasterAccount(
        request: GetMasterAccountRequest
    ): IO[AwsError, zio.aws.macie2.model.GetMasterAccountResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.GetMasterAccountRequest,
        GetMasterAccountResponse
      ]("getMasterAccount", api.getMasterAccount)(request.buildAwsValue())
        .map(zio.aws.macie2.model.GetMasterAccountResponse.wrap)
        .provideEnvironment(r)
    def listCustomDataIdentifiers(
        request: ListCustomDataIdentifiersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest,
      CustomDataIdentifierSummary,
      ListCustomDataIdentifiersPublisher
    ](
      "listCustomDataIdentifiers",
      api.listCustomDataIdentifiersPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item => zio.aws.macie2.model.CustomDataIdentifierSummary.wrap(item))
      .provideEnvironment(r)
    def listCustomDataIdentifiersPaginated(
        request: ListCustomDataIdentifiersRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.ListCustomDataIdentifiersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest,
      ListCustomDataIdentifiersResponse
    ]("listCustomDataIdentifiers", api.listCustomDataIdentifiers)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.ListCustomDataIdentifiersResponse.wrap)
      .provideEnvironment(r)
    def deleteInvitations(
        request: DeleteInvitationsRequest
    ): IO[AwsError, zio.aws.macie2.model.DeleteInvitationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest,
        DeleteInvitationsResponse
      ]("deleteInvitations", api.deleteInvitations)(request.buildAwsValue())
        .map(zio.aws.macie2.model.DeleteInvitationsResponse.wrap)
        .provideEnvironment(r)
    def updateClassificationJob(
        request: UpdateClassificationJobRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.UpdateClassificationJobRequest,
      UpdateClassificationJobResponse
    ]("updateClassificationJob", api.updateClassificationJob)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.UpdateClassificationJobResponse.wrap)
      .provideEnvironment(r)
    def testCustomDataIdentifier(request: TestCustomDataIdentifierRequest): IO[
      AwsError,
      zio.aws.macie2.model.TestCustomDataIdentifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest,
      TestCustomDataIdentifierResponse
    ]("testCustomDataIdentifier", api.testCustomDataIdentifier)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.TestCustomDataIdentifierResponse.wrap)
      .provideEnvironment(r)
    def updateRevealConfiguration(
        request: UpdateRevealConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.UpdateRevealConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest,
      UpdateRevealConfigurationResponse
    ]("updateRevealConfiguration", api.updateRevealConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.UpdateRevealConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteCustomDataIdentifier(
        request: DeleteCustomDataIdentifierRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.DeleteCustomDataIdentifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.DeleteCustomDataIdentifierRequest,
      DeleteCustomDataIdentifierResponse
    ]("deleteCustomDataIdentifier", api.deleteCustomDataIdentifier)(
      request.buildAwsValue()
    ).map(zio.aws.macie2.model.DeleteCustomDataIdentifierResponse.wrap)
      .provideEnvironment(r)
    def disassociateFromAdministratorAccount(
        request: DisassociateFromAdministratorAccountRequest
    ): IO[
      AwsError,
      zio.aws.macie2.model.DisassociateFromAdministratorAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.macie2.model.DisassociateFromAdministratorAccountRequest,
      DisassociateFromAdministratorAccountResponse
    ](
      "disassociateFromAdministratorAccount",
      api.disassociateFromAdministratorAccount
    )(request.buildAwsValue())
      .map(
        zio.aws.macie2.model.DisassociateFromAdministratorAccountResponse.wrap
      )
      .provideEnvironment(r)
    def getUsageStatistics(
        request: GetUsageStatisticsRequest
    ): ZStream[Any, AwsError, zio.aws.macie2.model.UsageRecord.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest,
        UsageRecord,
        GetUsageStatisticsPublisher
      ]("getUsageStatistics", api.getUsageStatisticsPaginator, _.records())(
        request.buildAwsValue()
      ).map(item => zio.aws.macie2.model.UsageRecord.wrap(item))
        .provideEnvironment(r)
    def getUsageStatisticsPaginated(
        request: GetUsageStatisticsRequest
    ): IO[AwsError, zio.aws.macie2.model.GetUsageStatisticsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest,
        GetUsageStatisticsResponse
      ]("getUsageStatistics", api.getUsageStatistics)(request.buildAwsValue())
        .map(zio.aws.macie2.model.GetUsageStatisticsResponse.wrap)
        .provideEnvironment(r)
    def updateMemberSession(
        request: UpdateMemberSessionRequest
    ): IO[AwsError, zio.aws.macie2.model.UpdateMemberSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.macie2.model.UpdateMemberSessionRequest,
        UpdateMemberSessionResponse
      ]("updateMemberSession", api.updateMemberSession)(request.buildAwsValue())
        .map(zio.aws.macie2.model.UpdateMemberSessionResponse.wrap)
        .provideEnvironment(r)
  }
  def getAdministratorAccount(request: GetAdministratorAccountRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetAdministratorAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAdministratorAccount(request))
  def listFindings(
      request: ListFindingsRequest
  ): ZStream[zio.aws.macie2.Macie2, AwsError, __string] =
    ZStream.serviceWithStream(_.listFindings(request))
  def listFindingsPaginated(request: ListFindingsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.ListFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindingsPaginated(request))
  def listClassificationJobs(request: ListClassificationJobsRequest): ZStream[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.JobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listClassificationJobs(request))
  def listClassificationJobsPaginated(
      request: ListClassificationJobsRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClassificationJobsPaginated(request))
  def disableOrganizationAdminAccount(
      request: DisableOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DisableOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableOrganizationAdminAccount(request))
  def createSampleFindings(request: CreateSampleFindingsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.CreateSampleFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSampleFindings(request))
  def getMacieSession(request: GetMacieSessionRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMacieSession(request))
  def createClassificationJob(request: CreateClassificationJobRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createClassificationJob(request))
  def listOrganizationAdminAccounts(
      request: ListOrganizationAdminAccountsRequest
  ): ZStream[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.AdminAccount.ReadOnly
  ] = ZStream.serviceWithStream(_.listOrganizationAdminAccounts(request))
  def listOrganizationAdminAccountsPaginated(
      request: ListOrganizationAdminAccountsRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOrganizationAdminAccountsPaginated(request))
  def updateOrganizationConfiguration(
      request: UpdateOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.UpdateOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOrganizationConfiguration(request))
  def updateFindingsFilter(request: UpdateFindingsFilterRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.UpdateFindingsFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFindingsFilter(request))
  def createMember(request: CreateMemberRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.CreateMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMember(request))
  def putFindingsPublicationConfiguration(
      request: PutFindingsPublicationConfigurationRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.PutFindingsPublicationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putFindingsPublicationConfiguration(request))
  def createInvitations(request: CreateInvitationsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.CreateInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInvitations(request))
  def disassociateMember(request: DisassociateMemberRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DisassociateMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMember(request))
  def listFindingsFilters(request: ListFindingsFiltersRequest): ZStream[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.FindingsFilterListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listFindingsFilters(request))
  def listFindingsFiltersPaginated(request: ListFindingsFiltersRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.ListFindingsFiltersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindingsFiltersPaginated(request))
  def getInvitationsCount(request: GetInvitationsCountRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetInvitationsCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInvitationsCount(request))
  def createCustomDataIdentifier(
      request: CreateCustomDataIdentifierRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.CreateCustomDataIdentifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomDataIdentifier(request))
  def updateMacieSession(request: UpdateMacieSessionRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.UpdateMacieSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMacieSession(request))
  def disassociateFromMasterAccount(
      request: DisassociateFromMasterAccountRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DisassociateFromMasterAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateFromMasterAccount(request))
  def putClassificationExportConfiguration(
      request: PutClassificationExportConfigurationRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.PutClassificationExportConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putClassificationExportConfiguration(request))
  def listMembers(request: ListMembersRequest): ZStream[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.Member.ReadOnly
  ] = ZStream.serviceWithStream(_.listMembers(request))
  def listMembersPaginated(request: ListMembersRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.ListMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMembersPaginated(request))
  def listManagedDataIdentifiers(
      request: ListManagedDataIdentifiersRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.ListManagedDataIdentifiersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listManagedDataIdentifiers(request))
  def describeBuckets(request: DescribeBucketsRequest): ZStream[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.BucketMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.describeBuckets(request))
  def describeBucketsPaginated(request: DescribeBucketsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DescribeBucketsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBucketsPaginated(request))
  def enableMacie(request: EnableMacieRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.EnableMacieResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableMacie(request))
  def getSensitiveDataOccurrencesAvailability(
      request: GetSensitiveDataOccurrencesAvailabilityRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSensitiveDataOccurrencesAvailability(request))
  def getFindingStatistics(request: GetFindingStatisticsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetFindingStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingStatistics(request))
  def getRevealConfiguration(request: GetRevealConfigurationRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetRevealConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRevealConfiguration(request))
  def searchResources(request: SearchResourcesRequest): ZStream[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.MatchingResource.ReadOnly
  ] = ZStream.serviceWithStream(_.searchResources(request))
  def searchResourcesPaginated(request: SearchResourcesRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.SearchResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchResourcesPaginated(request))
  def disableMacie(request: DisableMacieRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DisableMacieResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableMacie(request))
  def getSensitiveDataOccurrences(
      request: GetSensitiveDataOccurrencesRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSensitiveDataOccurrences(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getFindings(request: GetFindingsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindings(request))
  def getMember(request: GetMemberRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMember(request))
  def getCustomDataIdentifier(request: GetCustomDataIdentifierRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCustomDataIdentifier(request))
  def describeOrganizationConfiguration(
      request: DescribeOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrganizationConfiguration(request))
  def acceptInvitation(request: AcceptInvitationRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.AcceptInvitationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptInvitation(request))
  def deleteMember(request: DeleteMemberRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DeleteMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMember(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getFindingsPublicationConfiguration(
      request: GetFindingsPublicationConfigurationRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingsPublicationConfiguration(request))
  def getClassificationExportConfiguration(
      request: GetClassificationExportConfigurationRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetClassificationExportConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getClassificationExportConfiguration(request))
  def describeClassificationJob(request: DescribeClassificationJobRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClassificationJob(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listInvitations(request: ListInvitationsRequest): ZStream[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.Invitation.ReadOnly
  ] = ZStream.serviceWithStream(_.listInvitations(request))
  def listInvitationsPaginated(request: ListInvitationsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.ListInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInvitationsPaginated(request))
  def batchGetCustomDataIdentifiers(
      request: BatchGetCustomDataIdentifiersRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetCustomDataIdentifiers(request))
  def deleteFindingsFilter(request: DeleteFindingsFilterRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DeleteFindingsFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFindingsFilter(request))
  def getFindingsFilter(request: GetFindingsFilterRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingsFilter(request))
  def declineInvitations(request: DeclineInvitationsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DeclineInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.declineInvitations(request))
  def getUsageTotals(request: GetUsageTotalsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUsageTotals(request))
  def getBucketStatistics(request: GetBucketStatisticsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketStatistics(request))
  def createFindingsFilter(request: CreateFindingsFilterRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.CreateFindingsFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFindingsFilter(request))
  def enableOrganizationAdminAccount(
      request: EnableOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.EnableOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableOrganizationAdminAccount(request))
  def getMasterAccount(request: GetMasterAccountRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetMasterAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMasterAccount(request))
  def listCustomDataIdentifiers(
      request: ListCustomDataIdentifiersRequest
  ): ZStream[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCustomDataIdentifiers(request))
  def listCustomDataIdentifiersPaginated(
      request: ListCustomDataIdentifiersRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.ListCustomDataIdentifiersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCustomDataIdentifiersPaginated(request))
  def deleteInvitations(request: DeleteInvitationsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DeleteInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInvitations(request))
  def updateClassificationJob(
      request: UpdateClassificationJobRequest
  ): ZIO[zio.aws.macie2.Macie2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateClassificationJob(request))
  def testCustomDataIdentifier(request: TestCustomDataIdentifierRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.TestCustomDataIdentifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testCustomDataIdentifier(request))
  def updateRevealConfiguration(request: UpdateRevealConfigurationRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.UpdateRevealConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRevealConfiguration(request))
  def deleteCustomDataIdentifier(
      request: DeleteCustomDataIdentifierRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DeleteCustomDataIdentifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomDataIdentifier(request))
  def disassociateFromAdministratorAccount(
      request: DisassociateFromAdministratorAccountRequest
  ): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.DisassociateFromAdministratorAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateFromAdministratorAccount(request))
  def getUsageStatistics(request: GetUsageStatisticsRequest): ZStream[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.UsageRecord.ReadOnly
  ] = ZStream.serviceWithStream(_.getUsageStatistics(request))
  def getUsageStatisticsPaginated(request: GetUsageStatisticsRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.GetUsageStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUsageStatisticsPaginated(request))
  def updateMemberSession(request: UpdateMemberSessionRequest): ZIO[
    zio.aws.macie2.Macie2,
    AwsError,
    zio.aws.macie2.model.UpdateMemberSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMemberSession(request))
}
