package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserIdentity(
    assumedRole: Optional[zio.aws.macie2.model.AssumedRole] = Optional.Absent,
    awsAccount: Optional[zio.aws.macie2.model.AwsAccount] = Optional.Absent,
    awsService: Optional[zio.aws.macie2.model.AwsService] = Optional.Absent,
    federatedUser: Optional[zio.aws.macie2.model.FederatedUser] =
      Optional.Absent,
    iamUser: Optional[zio.aws.macie2.model.IamUser] = Optional.Absent,
    root: Optional[zio.aws.macie2.model.UserIdentityRoot] = Optional.Absent,
    `type`: Optional[zio.aws.macie2.model.UserIdentityType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UserIdentity = {
    import UserIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UserIdentity
      .builder()
      .optionallyWith(assumedRole.map(value => value.buildAwsValue()))(
        _.assumedRole
      )
      .optionallyWith(awsAccount.map(value => value.buildAwsValue()))(
        _.awsAccount
      )
      .optionallyWith(awsService.map(value => value.buildAwsValue()))(
        _.awsService
      )
      .optionallyWith(federatedUser.map(value => value.buildAwsValue()))(
        _.federatedUser
      )
      .optionallyWith(iamUser.map(value => value.buildAwsValue()))(_.iamUser)
      .optionallyWith(root.map(value => value.buildAwsValue()))(_.root)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UserIdentity.ReadOnly =
    zio.aws.macie2.model.UserIdentity.wrap(buildAwsValue())
}
object UserIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UserIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UserIdentity =
      zio.aws.macie2.model.UserIdentity(
        assumedRole.map(value => value.asEditable),
        awsAccount.map(value => value.asEditable),
        awsService.map(value => value.asEditable),
        federatedUser.map(value => value.asEditable),
        iamUser.map(value => value.asEditable),
        root.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def assumedRole: Optional[zio.aws.macie2.model.AssumedRole.ReadOnly]
    def awsAccount: Optional[zio.aws.macie2.model.AwsAccount.ReadOnly]
    def awsService: Optional[zio.aws.macie2.model.AwsService.ReadOnly]
    def federatedUser: Optional[zio.aws.macie2.model.FederatedUser.ReadOnly]
    def iamUser: Optional[zio.aws.macie2.model.IamUser.ReadOnly]
    def root: Optional[zio.aws.macie2.model.UserIdentityRoot.ReadOnly]
    def `type`: Optional[zio.aws.macie2.model.UserIdentityType]
    def getAssumedRole
        : ZIO[Any, AwsError, zio.aws.macie2.model.AssumedRole.ReadOnly] =
      AwsError.unwrapOptionField("assumedRole", assumedRole)
    def getAwsAccount
        : ZIO[Any, AwsError, zio.aws.macie2.model.AwsAccount.ReadOnly] =
      AwsError.unwrapOptionField("awsAccount", awsAccount)
    def getAwsService
        : ZIO[Any, AwsError, zio.aws.macie2.model.AwsService.ReadOnly] =
      AwsError.unwrapOptionField("awsService", awsService)
    def getFederatedUser
        : ZIO[Any, AwsError, zio.aws.macie2.model.FederatedUser.ReadOnly] =
      AwsError.unwrapOptionField("federatedUser", federatedUser)
    def getIamUser: ZIO[Any, AwsError, zio.aws.macie2.model.IamUser.ReadOnly] =
      AwsError.unwrapOptionField("iamUser", iamUser)
    def getRoot
        : ZIO[Any, AwsError, zio.aws.macie2.model.UserIdentityRoot.ReadOnly] =
      AwsError.unwrapOptionField("root", root)
    def getType: ZIO[Any, AwsError, zio.aws.macie2.model.UserIdentityType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UserIdentity
  ) extends zio.aws.macie2.model.UserIdentity.ReadOnly {
    override val assumedRole
        : Optional[zio.aws.macie2.model.AssumedRole.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assumedRole())
        .map(value => zio.aws.macie2.model.AssumedRole.wrap(value))
    override val awsAccount
        : Optional[zio.aws.macie2.model.AwsAccount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccount())
        .map(value => zio.aws.macie2.model.AwsAccount.wrap(value))
    override val awsService
        : Optional[zio.aws.macie2.model.AwsService.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsService())
        .map(value => zio.aws.macie2.model.AwsService.wrap(value))
    override val federatedUser
        : Optional[zio.aws.macie2.model.FederatedUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federatedUser())
        .map(value => zio.aws.macie2.model.FederatedUser.wrap(value))
    override val iamUser: Optional[zio.aws.macie2.model.IamUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamUser())
        .map(value => zio.aws.macie2.model.IamUser.wrap(value))
    override val root
        : Optional[zio.aws.macie2.model.UserIdentityRoot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.root())
        .map(value => zio.aws.macie2.model.UserIdentityRoot.wrap(value))
    override val `type`: Optional[zio.aws.macie2.model.UserIdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.macie2.model.UserIdentityType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UserIdentity
  ): zio.aws.macie2.model.UserIdentity.ReadOnly = new Wrapper(impl)
}
