package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UsageByAccount(
    currency: Optional[zio.aws.macie2.model.Currency] = Optional.Absent,
    estimatedCost: Optional[__string] = Optional.Absent,
    serviceLimit: Optional[zio.aws.macie2.model.ServiceLimit] = Optional.Absent,
    `type`: Optional[zio.aws.macie2.model.UsageType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UsageByAccount = {
    import UsageByAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UsageByAccount
      .builder()
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(estimatedCost.map(value => value: java.lang.String))(
        _.estimatedCost
      )
      .optionallyWith(serviceLimit.map(value => value.buildAwsValue()))(
        _.serviceLimit
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UsageByAccount.ReadOnly =
    zio.aws.macie2.model.UsageByAccount.wrap(buildAwsValue())
}
object UsageByAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UsageByAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UsageByAccount =
      zio.aws.macie2.model.UsageByAccount(
        currency.map(value => value),
        estimatedCost.map(value => value),
        serviceLimit.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def currency: Optional[zio.aws.macie2.model.Currency]
    def estimatedCost: Optional[__string]
    def serviceLimit: Optional[zio.aws.macie2.model.ServiceLimit.ReadOnly]
    def `type`: Optional[zio.aws.macie2.model.UsageType]
    def getCurrency: ZIO[Any, AwsError, zio.aws.macie2.model.Currency] =
      AwsError.unwrapOptionField("currency", currency)
    def getEstimatedCost: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("estimatedCost", estimatedCost)
    def getServiceLimit
        : ZIO[Any, AwsError, zio.aws.macie2.model.ServiceLimit.ReadOnly] =
      AwsError.unwrapOptionField("serviceLimit", serviceLimit)
    def getType: ZIO[Any, AwsError, zio.aws.macie2.model.UsageType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UsageByAccount
  ) extends zio.aws.macie2.model.UsageByAccount.ReadOnly {
    override val currency: Optional[zio.aws.macie2.model.Currency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currency())
        .map(value => zio.aws.macie2.model.Currency.wrap(value))
    override val estimatedCost: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.estimatedCost())
      .map(value => value: __string)
    override val serviceLimit
        : Optional[zio.aws.macie2.model.ServiceLimit.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceLimit())
        .map(value => zio.aws.macie2.model.ServiceLimit.wrap(value))
    override val `type`: Optional[zio.aws.macie2.model.UsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.macie2.model.UsageType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UsageByAccount
  ): zio.aws.macie2.model.UsageByAccount.ReadOnly = new Wrapper(impl)
}
