package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchResourcesTagCriterion(
    comparator: Optional[zio.aws.macie2.model.SearchResourcesComparator] =
      Optional.Absent,
    tagValues: Optional[
      Iterable[zio.aws.macie2.model.SearchResourcesTagCriterionPair]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SearchResourcesTagCriterion = {
    import SearchResourcesTagCriterion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SearchResourcesTagCriterion
      .builder()
      .optionallyWith(comparator.map(value => value.unwrap))(_.comparator)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SearchResourcesTagCriterion.ReadOnly =
    zio.aws.macie2.model.SearchResourcesTagCriterion.wrap(buildAwsValue())
}
object SearchResourcesTagCriterion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SearchResourcesTagCriterion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SearchResourcesTagCriterion =
      zio.aws.macie2.model.SearchResourcesTagCriterion(
        comparator.map(value => value),
        tagValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def comparator: Optional[zio.aws.macie2.model.SearchResourcesComparator]
    def tagValues: Optional[
      List[zio.aws.macie2.model.SearchResourcesTagCriterionPair.ReadOnly]
    ]
    def getComparator
        : ZIO[Any, AwsError, zio.aws.macie2.model.SearchResourcesComparator] =
      AwsError.unwrapOptionField("comparator", comparator)
    def getTagValues: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.SearchResourcesTagCriterionPair.ReadOnly
    ]] = AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesTagCriterion
  ) extends zio.aws.macie2.model.SearchResourcesTagCriterion.ReadOnly {
    override val comparator
        : Optional[zio.aws.macie2.model.SearchResourcesComparator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparator())
        .map(value =>
          zio.aws.macie2.model.SearchResourcesComparator.wrap(value)
        )
    override val tagValues: Optional[
      List[zio.aws.macie2.model.SearchResourcesTagCriterionPair.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.SearchResourcesTagCriterionPair.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesTagCriterion
  ): zio.aws.macie2.model.SearchResourcesTagCriterion.ReadOnly = new Wrapper(
    impl
  )
}
