package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait RelationshipStatus {
  def unwrap: software.amazon.awssdk.services.macie2.model.RelationshipStatus
}
object RelationshipStatus {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.RelationshipStatus
  ): zio.aws.macie2.model.RelationshipStatus = value match {
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.PAUSED =>
      val r = Paused
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.INVITED =>
      val r = Invited
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.CREATED =>
      val r = Created
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.REMOVED =>
      val r = Removed
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.RESIGNED =>
      val r = Resigned
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.EMAIL_VERIFICATION_IN_PROGRESS =>
      val r = EmailVerificationInProgress
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.EMAIL_VERIFICATION_FAILED =>
      val r = EmailVerificationFailed
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.REGION_DISABLED =>
      val r = RegionDisabled
      r
    case software.amazon.awssdk.services.macie2.model.RelationshipStatus.ACCOUNT_SUSPENDED =>
      val r = AccountSuspended
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.ENABLED
  }
  case object Paused extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.PAUSED
  }
  case object Invited extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.INVITED
  }
  case object Created extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.CREATED
  }
  case object Removed extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.REMOVED
  }
  case object Resigned extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.RESIGNED
  }
  case object EmailVerificationInProgress
      extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.EMAIL_VERIFICATION_IN_PROGRESS
  }
  case object EmailVerificationFailed
      extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.EMAIL_VERIFICATION_FAILED
  }
  case object RegionDisabled extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.REGION_DISABLED
  }
  case object AccountSuspended extends zio.aws.macie2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RelationshipStatus =
      software.amazon.awssdk.services.macie2.model.RelationshipStatus.ACCOUNT_SUSPENDED
  }
}
