package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateFindingsFilterRequest(
    action: zio.aws.macie2.model.FindingsFilterAction,
    clientToken: Optional[__string] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    findingCriteria: zio.aws.macie2.model.FindingCriteria,
    name: __string,
    position: Optional[__integer] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest = {
    import CreateFindingsFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest
      .builder()
      .action(action.unwrap)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .findingCriteria(findingCriteria.buildAwsValue())
      .name(name: java.lang.String)
      .optionallyWith(position.map(value => value: Integer))(_.position)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateFindingsFilterRequest.ReadOnly =
    zio.aws.macie2.model.CreateFindingsFilterRequest.wrap(buildAwsValue())
}
object CreateFindingsFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateFindingsFilterRequest =
      zio.aws.macie2.model.CreateFindingsFilterRequest(
        action,
        clientToken.map(value => value),
        description.map(value => value),
        findingCriteria.asEditable,
        name,
        position.map(value => value),
        tags.map(value => value)
      )
    def action: zio.aws.macie2.model.FindingsFilterAction
    def clientToken: Optional[__string]
    def description: Optional[__string]
    def findingCriteria: zio.aws.macie2.model.FindingCriteria.ReadOnly
    def name: __string
    def position: Optional[__integer]
    def tags: Optional[Map[__string, __string]]
    def getAction
        : ZIO[Any, Nothing, zio.aws.macie2.model.FindingsFilterAction] =
      ZIO.succeed(action)
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getFindingCriteria
        : ZIO[Any, Nothing, zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      ZIO.succeed(findingCriteria)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getPosition: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("position", position)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest
  ) extends zio.aws.macie2.model.CreateFindingsFilterRequest.ReadOnly {
    override val action: zio.aws.macie2.model.FindingsFilterAction =
      zio.aws.macie2.model.FindingsFilterAction.wrap(impl.action())
    override val clientToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: __string)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val findingCriteria
        : zio.aws.macie2.model.FindingCriteria.ReadOnly =
      zio.aws.macie2.model.FindingCriteria.wrap(impl.findingCriteria())
    override val name: __string = impl.name(): __string
    override val position: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: __integer)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest
  ): zio.aws.macie2.model.CreateFindingsFilterRequest.ReadOnly = new Wrapper(
    impl
  )
}
