package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class JobDetails(
    isDefinedInJob: Optional[zio.aws.macie2.model.IsDefinedInJob] =
      Optional.Absent,
    isMonitoredByJob: Optional[zio.aws.macie2.model.IsMonitoredByJob] =
      Optional.Absent,
    lastJobId: Optional[__string] = Optional.Absent,
    lastJobRunTime: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.JobDetails = {
    import JobDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.JobDetails
      .builder()
      .optionallyWith(isDefinedInJob.map(value => value.unwrap))(
        _.isDefinedInJob
      )
      .optionallyWith(isMonitoredByJob.map(value => value.unwrap))(
        _.isMonitoredByJob
      )
      .optionallyWith(lastJobId.map(value => value: java.lang.String))(
        _.lastJobId
      )
      .optionallyWith(lastJobRunTime.map(value => value: Instant))(
        _.lastJobRunTime
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.JobDetails.ReadOnly =
    zio.aws.macie2.model.JobDetails.wrap(buildAwsValue())
}
object JobDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.JobDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.JobDetails =
      zio.aws.macie2.model.JobDetails(
        isDefinedInJob.map(value => value),
        isMonitoredByJob.map(value => value),
        lastJobId.map(value => value),
        lastJobRunTime.map(value => value)
      )
    def isDefinedInJob: Optional[zio.aws.macie2.model.IsDefinedInJob]
    def isMonitoredByJob: Optional[zio.aws.macie2.model.IsMonitoredByJob]
    def lastJobId: Optional[__string]
    def lastJobRunTime: Optional[__timestampIso8601]
    def getIsDefinedInJob
        : ZIO[Any, AwsError, zio.aws.macie2.model.IsDefinedInJob] =
      AwsError.unwrapOptionField("isDefinedInJob", isDefinedInJob)
    def getIsMonitoredByJob
        : ZIO[Any, AwsError, zio.aws.macie2.model.IsMonitoredByJob] =
      AwsError.unwrapOptionField("isMonitoredByJob", isMonitoredByJob)
    def getLastJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastJobId", lastJobId)
    def getLastJobRunTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastJobRunTime", lastJobRunTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.JobDetails
  ) extends zio.aws.macie2.model.JobDetails.ReadOnly {
    override val isDefinedInJob: Optional[zio.aws.macie2.model.IsDefinedInJob] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isDefinedInJob())
        .map(value => zio.aws.macie2.model.IsDefinedInJob.wrap(value))
    override val isMonitoredByJob
        : Optional[zio.aws.macie2.model.IsMonitoredByJob] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isMonitoredByJob())
        .map(value => zio.aws.macie2.model.IsMonitoredByJob.wrap(value))
    override val lastJobId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastJobId())
      .map(value => value: __string)
    override val lastJobRunTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastJobRunTime())
        .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.JobDetails
  ): zio.aws.macie2.model.JobDetails.ReadOnly = new Wrapper(impl)
}
