package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateFindingsFilterRequest(
    action: Optional[zio.aws.macie2.model.FindingsFilterAction] =
      Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    findingCriteria: Optional[zio.aws.macie2.model.FindingCriteria] =
      Optional.Absent,
    id: __string,
    name: Optional[__string] = Optional.Absent,
    position: Optional[__integer] = Optional.Absent,
    clientToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest = {
    import UpdateFindingsFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(findingCriteria.map(value => value.buildAwsValue()))(
        _.findingCriteria
      )
      .id(id: java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(position.map(value => value: Integer))(_.position)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UpdateFindingsFilterRequest.ReadOnly =
    zio.aws.macie2.model.UpdateFindingsFilterRequest.wrap(buildAwsValue())
}
object UpdateFindingsFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateFindingsFilterRequest =
      zio.aws.macie2.model.UpdateFindingsFilterRequest(
        action.map(value => value),
        description.map(value => value),
        findingCriteria.map(value => value.asEditable),
        id,
        name.map(value => value),
        position.map(value => value),
        clientToken.map(value => value)
      )
    def action: Optional[zio.aws.macie2.model.FindingsFilterAction]
    def description: Optional[__string]
    def findingCriteria: Optional[zio.aws.macie2.model.FindingCriteria.ReadOnly]
    def id: __string
    def name: Optional[__string]
    def position: Optional[__integer]
    def clientToken: Optional[__string]
    def getAction
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingsFilterAction] =
      AwsError.unwrapOptionField("action", action)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getFindingCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      AwsError.unwrapOptionField("findingCriteria", findingCriteria)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPosition: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("position", position)
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest
  ) extends zio.aws.macie2.model.UpdateFindingsFilterRequest.ReadOnly {
    override val action: Optional[zio.aws.macie2.model.FindingsFilterAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.macie2.model.FindingsFilterAction.wrap(value))
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val findingCriteria
        : Optional[zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingCriteria())
        .map(value => zio.aws.macie2.model.FindingCriteria.wrap(value))
    override val id: __string = impl.id(): __string
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val position: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: __integer)
    override val clientToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest
  ): zio.aws.macie2.model.UpdateFindingsFilterRequest.ReadOnly = new Wrapper(
    impl
  )
}
