package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Invitation(
    accountId: Optional[__string] = Optional.Absent,
    invitationId: Optional[__string] = Optional.Absent,
    invitedAt: Optional[__timestampIso8601] = Optional.Absent,
    relationshipStatus: Optional[zio.aws.macie2.model.RelationshipStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.Invitation = {
    import Invitation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Invitation
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(invitationId.map(value => value: java.lang.String))(
        _.invitationId
      )
      .optionallyWith(invitedAt.map(value => value: Instant))(_.invitedAt)
      .optionallyWith(relationshipStatus.map(value => value.unwrap))(
        _.relationshipStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Invitation.ReadOnly =
    zio.aws.macie2.model.Invitation.wrap(buildAwsValue())
}
object Invitation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Invitation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Invitation =
      zio.aws.macie2.model.Invitation(
        accountId.map(value => value),
        invitationId.map(value => value),
        invitedAt.map(value => value),
        relationshipStatus.map(value => value)
      )
    def accountId: Optional[__string]
    def invitationId: Optional[__string]
    def invitedAt: Optional[__timestampIso8601]
    def relationshipStatus: Optional[zio.aws.macie2.model.RelationshipStatus]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getInvitationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("invitationId", invitationId)
    def getInvitedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("invitedAt", invitedAt)
    def getRelationshipStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.RelationshipStatus] =
      AwsError.unwrapOptionField("relationshipStatus", relationshipStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Invitation
  ) extends zio.aws.macie2.model.Invitation.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val invitationId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.invitationId())
      .map(value => value: __string)
    override val invitedAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.invitedAt())
      .map(value => value: __timestampIso8601)
    override val relationshipStatus
        : Optional[zio.aws.macie2.model.RelationshipStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationshipStatus())
        .map(value => zio.aws.macie2.model.RelationshipStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Invitation
  ): zio.aws.macie2.model.Invitation.ReadOnly = new Wrapper(impl)
}
