package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountLevelPermissions(
    blockPublicAccess: Optional[zio.aws.macie2.model.BlockPublicAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AccountLevelPermissions = {
    import AccountLevelPermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AccountLevelPermissions
      .builder()
      .optionallyWith(blockPublicAccess.map(value => value.buildAwsValue()))(
        _.blockPublicAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AccountLevelPermissions.ReadOnly =
    zio.aws.macie2.model.AccountLevelPermissions.wrap(buildAwsValue())
}
object AccountLevelPermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AccountLevelPermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AccountLevelPermissions =
      zio.aws.macie2.model.AccountLevelPermissions(
        blockPublicAccess.map(value => value.asEditable)
      )
    def blockPublicAccess
        : Optional[zio.aws.macie2.model.BlockPublicAccess.ReadOnly]
    def getBlockPublicAccess
        : ZIO[Any, AwsError, zio.aws.macie2.model.BlockPublicAccess.ReadOnly] =
      AwsError.unwrapOptionField("blockPublicAccess", blockPublicAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AccountLevelPermissions
  ) extends zio.aws.macie2.model.AccountLevelPermissions.ReadOnly {
    override val blockPublicAccess
        : Optional[zio.aws.macie2.model.BlockPublicAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockPublicAccess())
        .map(value => zio.aws.macie2.model.BlockPublicAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AccountLevelPermissions
  ): zio.aws.macie2.model.AccountLevelPermissions.ReadOnly = new Wrapper(impl)
}
