package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__boolean, __timestampIso8601}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SessionContextAttributes(
    creationDate: Optional[__timestampIso8601] = Optional.Absent,
    mfaAuthenticated: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SessionContextAttributes = {
    import SessionContextAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SessionContextAttributes
      .builder()
      .optionallyWith(creationDate.map(value => value: Instant))(_.creationDate)
      .optionallyWith(mfaAuthenticated.map(value => value: java.lang.Boolean))(
        _.mfaAuthenticated
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SessionContextAttributes.ReadOnly =
    zio.aws.macie2.model.SessionContextAttributes.wrap(buildAwsValue())
}
object SessionContextAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SessionContextAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SessionContextAttributes =
      zio.aws.macie2.model.SessionContextAttributes(
        creationDate.map(value => value),
        mfaAuthenticated.map(value => value)
      )
    def creationDate: Optional[__timestampIso8601]
    def mfaAuthenticated: Optional[__boolean]
    def getCreationDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getMfaAuthenticated: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("mfaAuthenticated", mfaAuthenticated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SessionContextAttributes
  ) extends zio.aws.macie2.model.SessionContextAttributes.ReadOnly {
    override val creationDate: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationDate())
        .map(value => value: __timestampIso8601)
    override val mfaAuthenticated: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.mfaAuthenticated())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SessionContextAttributes
  ): zio.aws.macie2.model.SessionContextAttributes.ReadOnly = new Wrapper(impl)
}
