package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAccount(
    accountId: Optional[__string] = Optional.Absent,
    principalId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AwsAccount = {
    import AwsAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AwsAccount
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AwsAccount.ReadOnly =
    zio.aws.macie2.model.AwsAccount.wrap(buildAwsValue())
}
object AwsAccount {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.AwsAccount] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AwsAccount =
      zio.aws.macie2.model.AwsAccount(
        accountId.map(value => value),
        principalId.map(value => value)
      )
    def accountId: Optional[__string]
    def principalId: Optional[__string]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getPrincipalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("principalId", principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AwsAccount
  ) extends zio.aws.macie2.model.AwsAccount.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val principalId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AwsAccount
  ): zio.aws.macie2.model.AwsAccount.ReadOnly = new Wrapper(impl)
}
