package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait SeverityDescription {
  def unwrap: software.amazon.awssdk.services.macie2.model.SeverityDescription
}
object SeverityDescription {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.SeverityDescription
  ): zio.aws.macie2.model.SeverityDescription = value match {
    case software.amazon.awssdk.services.macie2.model.SeverityDescription.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.SeverityDescription.LOW =>
      val r = Low
      r
    case software.amazon.awssdk.services.macie2.model.SeverityDescription.MEDIUM =>
      val r = Medium
      r
    case software.amazon.awssdk.services.macie2.model.SeverityDescription.HIGH =>
      val r = High
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.SeverityDescription {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SeverityDescription =
      software.amazon.awssdk.services.macie2.model.SeverityDescription.UNKNOWN_TO_SDK_VERSION
  }
  case object Low extends zio.aws.macie2.model.SeverityDescription {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SeverityDescription =
      software.amazon.awssdk.services.macie2.model.SeverityDescription.LOW
  }
  case object Medium extends zio.aws.macie2.model.SeverityDescription {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SeverityDescription =
      software.amazon.awssdk.services.macie2.model.SeverityDescription.MEDIUM
  }
  case object High extends zio.aws.macie2.model.SeverityDescription {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SeverityDescription =
      software.amazon.awssdk.services.macie2.model.SeverityDescription.HIGH
  }
}
