package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__double
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpGeoLocation(
    lat: Optional[__double] = Optional.Absent,
    lon: Optional[__double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.IpGeoLocation = {
    import IpGeoLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.IpGeoLocation
      .builder()
      .optionallyWith(lat.map(value => value: java.lang.Double))(_.lat)
      .optionallyWith(lon.map(value => value: java.lang.Double))(_.lon)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.IpGeoLocation.ReadOnly =
    zio.aws.macie2.model.IpGeoLocation.wrap(buildAwsValue())
}
object IpGeoLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.IpGeoLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.IpGeoLocation = zio.aws.macie2.model
      .IpGeoLocation(lat.map(value => value), lon.map(value => value))
    def lat: Optional[__double]
    def lon: Optional[__double]
    def getLat: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("lat", lat)
    def getLon: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("lon", lon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.IpGeoLocation
  ) extends zio.aws.macie2.model.IpGeoLocation.ReadOnly {
    override val lat: Optional[__double] = zio.aws.core.internal
      .optionalFromNullable(impl.lat())
      .map(value => value: __double)
    override val lon: Optional[__double] = zio.aws.core.internal
      .optionalFromNullable(impl.lon())
      .map(value => value: __double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.IpGeoLocation
  ): zio.aws.macie2.model.IpGeoLocation.ReadOnly = new Wrapper(impl)
}
