package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3BucketOwner(
    displayName: Optional[__string] = Optional.Absent,
    id: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3BucketOwner = {
    import S3BucketOwner.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3BucketOwner
      .builder()
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3BucketOwner.ReadOnly =
    zio.aws.macie2.model.S3BucketOwner.wrap(buildAwsValue())
}
object S3BucketOwner {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3BucketOwner
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3BucketOwner = zio.aws.macie2.model
      .S3BucketOwner(displayName.map(value => value), id.map(value => value))
    def displayName: Optional[__string]
    def id: Optional[__string]
    def getDisplayName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3BucketOwner
  ) extends zio.aws.macie2.model.S3BucketOwner.ReadOnly {
    override val displayName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: __string)
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3BucketOwner
  ): zio.aws.macie2.model.S3BucketOwner.ReadOnly = new Wrapper(impl)
}
