package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BucketCountPolicyAllowsUnencryptedObjectUploads(
    allowsUnencryptedObjectUploads: Optional[__long] = Optional.Absent,
    deniesUnencryptedObjectUploads: Optional[__long] = Optional.Absent,
    unknown: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads = {
    import BucketCountPolicyAllowsUnencryptedObjectUploads.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
      .builder()
      .optionallyWith(
        allowsUnencryptedObjectUploads.map(value => value: java.lang.Long)
      )(_.allowsUnencryptedObjectUploads)
      .optionallyWith(
        deniesUnencryptedObjectUploads.map(value => value: java.lang.Long)
      )(_.deniesUnencryptedObjectUploads)
      .optionallyWith(unknown.map(value => value: java.lang.Long))(_.unknown)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.ReadOnly =
    zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
      .wrap(buildAwsValue())
}
object BucketCountPolicyAllowsUnencryptedObjectUploads {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads =
      zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads(
        allowsUnencryptedObjectUploads.map(value => value),
        deniesUnencryptedObjectUploads.map(value => value),
        unknown.map(value => value)
      )
    def allowsUnencryptedObjectUploads: Optional[__long]
    def deniesUnencryptedObjectUploads: Optional[__long]
    def unknown: Optional[__long]
    def getAllowsUnencryptedObjectUploads: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField(
        "allowsUnencryptedObjectUploads",
        allowsUnencryptedObjectUploads
      )
    def getDeniesUnencryptedObjectUploads: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField(
        "deniesUnencryptedObjectUploads",
        deniesUnencryptedObjectUploads
      )
    def getUnknown: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("unknown", unknown)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
  ) extends zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.ReadOnly {
    override val allowsUnencryptedObjectUploads: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsUnencryptedObjectUploads())
        .map(value => value: __long)
    override val deniesUnencryptedObjectUploads: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deniesUnencryptedObjectUploads())
        .map(value => value: __long)
    override val unknown: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.unknown())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
  ): zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.ReadOnly =
    new Wrapper(impl)
}
