package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SessionIssuer(
    accountId: Optional[__string] = Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    principalId: Optional[__string] = Optional.Absent,
    `type`: Optional[__string] = Optional.Absent,
    userName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SessionIssuer = {
    import SessionIssuer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SessionIssuer
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(userName.map(value => value: java.lang.String))(
        _.userName
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SessionIssuer.ReadOnly =
    zio.aws.macie2.model.SessionIssuer.wrap(buildAwsValue())
}
object SessionIssuer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SessionIssuer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SessionIssuer =
      zio.aws.macie2.model.SessionIssuer(
        accountId.map(value => value),
        arn.map(value => value),
        principalId.map(value => value),
        `type`.map(value => value),
        userName.map(value => value)
      )
    def accountId: Optional[__string]
    def arn: Optional[__string]
    def principalId: Optional[__string]
    def `type`: Optional[__string]
    def userName: Optional[__string]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getPrincipalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
    def getUserName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SessionIssuer
  ) extends zio.aws.macie2.model.SessionIssuer.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val principalId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: __string)
    override val `type`: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: __string)
    override val userName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SessionIssuer
  ): zio.aws.macie2.model.SessionIssuer.ReadOnly = new Wrapper(impl)
}
