package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait TimeRange {
  def unwrap: software.amazon.awssdk.services.macie2.model.TimeRange
}
object TimeRange {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.TimeRange
  ): zio.aws.macie2.model.TimeRange = value match {
    case software.amazon.awssdk.services.macie2.model.TimeRange.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.TimeRange.MONTH_TO_DATE =>
      val r = MONTH_TO_DATE
      r
    case software.amazon.awssdk.services.macie2.model.TimeRange.PAST_30_DAYS =>
      val r = PAST_30_DAYS
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.TimeRange {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.TimeRange =
      software.amazon.awssdk.services.macie2.model.TimeRange.UNKNOWN_TO_SDK_VERSION
  }
  case object MONTH_TO_DATE extends zio.aws.macie2.model.TimeRange {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.TimeRange =
      software.amazon.awssdk.services.macie2.model.TimeRange.MONTH_TO_DATE
  }
  case object PAST_30_DAYS extends zio.aws.macie2.model.TimeRange {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.TimeRange =
      software.amazon.awssdk.services.macie2.model.TimeRange.PAST_30_DAYS
  }
}
