package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FindingAction(
    actionType: Optional[zio.aws.macie2.model.FindingActionType] =
      Optional.Absent,
    apiCallDetails: Optional[zio.aws.macie2.model.ApiCallDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.FindingAction = {
    import FindingAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.FindingAction
      .builder()
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(apiCallDetails.map(value => value.buildAwsValue()))(
        _.apiCallDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.FindingAction.ReadOnly =
    zio.aws.macie2.model.FindingAction.wrap(buildAwsValue())
}
object FindingAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.FindingAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.FindingAction =
      zio.aws.macie2.model.FindingAction(
        actionType.map(value => value),
        apiCallDetails.map(value => value.asEditable)
      )
    def actionType: Optional[zio.aws.macie2.model.FindingActionType]
    def apiCallDetails: Optional[zio.aws.macie2.model.ApiCallDetails.ReadOnly]
    def getActionType
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getApiCallDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.ApiCallDetails.ReadOnly] =
      AwsError.unwrapOptionField("apiCallDetails", apiCallDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.FindingAction
  ) extends zio.aws.macie2.model.FindingAction.ReadOnly {
    override val actionType: Optional[zio.aws.macie2.model.FindingActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value => zio.aws.macie2.model.FindingActionType.wrap(value))
    override val apiCallDetails
        : Optional[zio.aws.macie2.model.ApiCallDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiCallDetails())
        .map(value => zio.aws.macie2.model.ApiCallDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.FindingAction
  ): zio.aws.macie2.model.FindingAction.ReadOnly = new Wrapper(impl)
}
