package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClassificationDetails(
    detailedResultsLocation: Optional[__string] = Optional.Absent,
    jobArn: Optional[__string] = Optional.Absent,
    jobId: Optional[__string] = Optional.Absent,
    result: Optional[zio.aws.macie2.model.ClassificationResult] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ClassificationDetails = {
    import ClassificationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ClassificationDetails
      .builder()
      .optionallyWith(
        detailedResultsLocation.map(value => value: java.lang.String)
      )(_.detailedResultsLocation)
      .optionallyWith(jobArn.map(value => value: java.lang.String))(_.jobArn)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(result.map(value => value.buildAwsValue()))(_.result)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ClassificationDetails.ReadOnly =
    zio.aws.macie2.model.ClassificationDetails.wrap(buildAwsValue())
}
object ClassificationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ClassificationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ClassificationDetails =
      zio.aws.macie2.model.ClassificationDetails(
        detailedResultsLocation.map(value => value),
        jobArn.map(value => value),
        jobId.map(value => value),
        result.map(value => value.asEditable)
      )
    def detailedResultsLocation: Optional[__string]
    def jobArn: Optional[__string]
    def jobId: Optional[__string]
    def result: Optional[zio.aws.macie2.model.ClassificationResult.ReadOnly]
    def getDetailedResultsLocation: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("detailedResultsLocation", detailedResultsLocation)
    def getJobArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getResult: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ClassificationResult.ReadOnly
    ] = AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationDetails
  ) extends zio.aws.macie2.model.ClassificationDetails.ReadOnly {
    override val detailedResultsLocation: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detailedResultsLocation())
        .map(value => value: __string)
    override val jobArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => value: __string)
    override val jobId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => value: __string)
    override val result
        : Optional[zio.aws.macie2.model.ClassificationResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value => zio.aws.macie2.model.ClassificationResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationDetails
  ): zio.aws.macie2.model.ClassificationDetails.ReadOnly = new Wrapper(impl)
}
