package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UnprocessedAccount(
    accountId: Option[__string] = None,
    errorCode: Option[zio.aws.macie2.model.ErrorCode] = None,
    errorMessage: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UnprocessedAccount = {
    import UnprocessedAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UnprocessedAccount
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UnprocessedAccount.ReadOnly =
    zio.aws.macie2.model.UnprocessedAccount.wrap(buildAwsValue())
}
object UnprocessedAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UnprocessedAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UnprocessedAccount =
      zio.aws.macie2.model.UnprocessedAccount(
        accountId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def accountId: Option[__string]
    def errorCode: Option[zio.aws.macie2.model.ErrorCode]
    def errorMessage: Option[__string]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.macie2.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UnprocessedAccount
  ) extends zio.aws.macie2.model.UnprocessedAccount.ReadOnly {
    override val accountId: Option[__string] =
      scala.Option(impl.accountId()).map(value => value: __string)
    override val errorCode: Option[zio.aws.macie2.model.ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.macie2.model.ErrorCode.wrap(value))
    override val errorMessage: Option[__string] =
      scala.Option(impl.errorMessage()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UnprocessedAccount
  ): zio.aws.macie2.model.UnprocessedAccount.ReadOnly = new Wrapper(impl)
}
