package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListOrganizationAdminAccountsResponse(
    adminAccounts: Option[Iterable[zio.aws.macie2.model.AdminAccount]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse = {
    import ListOrganizationAdminAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse
      .builder()
      .optionallyWith(
        adminAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adminAccounts)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    zio.aws.macie2.model.ListOrganizationAdminAccountsResponse
      .wrap(buildAwsValue())
}
object ListOrganizationAdminAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListOrganizationAdminAccountsResponse =
      zio.aws.macie2.model.ListOrganizationAdminAccountsResponse(
        adminAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def adminAccounts: Option[List[zio.aws.macie2.model.AdminAccount.ReadOnly]]
    def nextToken: Option[__string]
    def getAdminAccounts
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.AdminAccount.ReadOnly]] =
      AwsError.unwrapOptionField("adminAccounts", adminAccounts)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse
  ) extends zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly {
    override val adminAccounts
        : Option[List[zio.aws.macie2.model.AdminAccount.ReadOnly]] = scala
      .Option(impl.adminAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.AdminAccount.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse
  ): zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
