package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class TagScopeTerm(
    comparator: Option[zio.aws.macie2.model.JobComparator] = None,
    key: Option[__string] = None,
    tagValues: Option[Iterable[zio.aws.macie2.model.TagValuePair]] = None,
    target: Option[zio.aws.macie2.model.TagTarget] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.TagScopeTerm = {
    import TagScopeTerm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.TagScopeTerm
      .builder()
      .optionallyWith(comparator.map(value => value.unwrap))(_.comparator)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagValues)
      .optionallyWith(target.map(value => value.unwrap))(_.target)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.TagScopeTerm.ReadOnly =
    zio.aws.macie2.model.TagScopeTerm.wrap(buildAwsValue())
}
object TagScopeTerm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.TagScopeTerm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.TagScopeTerm =
      zio.aws.macie2.model.TagScopeTerm(
        comparator.map(value => value),
        key.map(value => value),
        tagValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        target.map(value => value)
      )
    def comparator: Option[zio.aws.macie2.model.JobComparator]
    def key: Option[__string]
    def tagValues: Option[List[zio.aws.macie2.model.TagValuePair.ReadOnly]]
    def target: Option[zio.aws.macie2.model.TagTarget]
    def getComparator: ZIO[Any, AwsError, zio.aws.macie2.model.JobComparator] =
      AwsError.unwrapOptionField("comparator", comparator)
    def getKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("key", key)
    def getTagValues
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.TagValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
    def getTarget: ZIO[Any, AwsError, zio.aws.macie2.model.TagTarget] =
      AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.TagScopeTerm
  ) extends zio.aws.macie2.model.TagScopeTerm.ReadOnly {
    override val comparator: Option[zio.aws.macie2.model.JobComparator] = scala
      .Option(impl.comparator())
      .map(value => zio.aws.macie2.model.JobComparator.wrap(value))
    override val key: Option[__string] =
      scala.Option(impl.key()).map(value => value: __string)
    override val tagValues
        : Option[List[zio.aws.macie2.model.TagValuePair.ReadOnly]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.TagValuePair.wrap(item)
        }.toList
      )
    override val target: Option[zio.aws.macie2.model.TagTarget] = scala
      .Option(impl.target())
      .map(value => zio.aws.macie2.model.TagTarget.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.TagScopeTerm
  ): zio.aws.macie2.model.TagScopeTerm.ReadOnly = new Wrapper(impl)
}
