package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import scala.jdk.CollectionConverters._
final case class SensitiveDataItem(
    category: Option[zio.aws.macie2.model.SensitiveDataItemCategory] = None,
    detections: Option[Iterable[zio.aws.macie2.model.DefaultDetection]] = None,
    totalCount: Option[__long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SensitiveDataItem = {
    import SensitiveDataItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SensitiveDataItem
      .builder()
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(
        detections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.detections)
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SensitiveDataItem.ReadOnly =
    zio.aws.macie2.model.SensitiveDataItem.wrap(buildAwsValue())
}
object SensitiveDataItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SensitiveDataItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SensitiveDataItem =
      zio.aws.macie2.model.SensitiveDataItem(
        category.map(value => value),
        detections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalCount.map(value => value)
      )
    def category: Option[zio.aws.macie2.model.SensitiveDataItemCategory]
    def detections: Option[List[zio.aws.macie2.model.DefaultDetection.ReadOnly]]
    def totalCount: Option[__long]
    def getCategory
        : ZIO[Any, AwsError, zio.aws.macie2.model.SensitiveDataItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getDetections: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.DefaultDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("detections", detections)
    def getTotalCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SensitiveDataItem
  ) extends zio.aws.macie2.model.SensitiveDataItem.ReadOnly {
    override val category
        : Option[zio.aws.macie2.model.SensitiveDataItemCategory] = scala
      .Option(impl.category())
      .map(value => zio.aws.macie2.model.SensitiveDataItemCategory.wrap(value))
    override val detections
        : Option[List[zio.aws.macie2.model.DefaultDetection.ReadOnly]] = scala
      .Option(impl.detections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.DefaultDetection.wrap(item)
        }.toList
      )
    override val totalCount: Option[__long] =
      scala.Option(impl.totalCount()).map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SensitiveDataItem
  ): zio.aws.macie2.model.SensitiveDataItem.ReadOnly = new Wrapper(impl)
}
