package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListMembersRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    onlyAssociated: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListMembersRequest = {
    import ListMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListMembersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(onlyAssociated.map(value => value: java.lang.String))(
        _.onlyAssociated
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListMembersRequest.ReadOnly =
    zio.aws.macie2.model.ListMembersRequest.wrap(buildAwsValue())
}
object ListMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListMembersRequest =
      zio.aws.macie2.model.ListMembersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        onlyAssociated.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def onlyAssociated: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOnlyAssociated: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("onlyAssociated", onlyAssociated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListMembersRequest
  ) extends zio.aws.macie2.model.ListMembersRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.macie2.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val onlyAssociated: Option[__string] =
      scala.Option(impl.onlyAssociated()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListMembersRequest
  ): zio.aws.macie2.model.ListMembersRequest.ReadOnly = new Wrapper(impl)
}
