package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListJobsFilterCriteria(
    excludes: Option[Iterable[zio.aws.macie2.model.ListJobsFilterTerm]] = None,
    includes: Option[Iterable[zio.aws.macie2.model.ListJobsFilterTerm]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria = {
    import ListJobsFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria
      .builder()
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListJobsFilterCriteria.ReadOnly =
    zio.aws.macie2.model.ListJobsFilterCriteria.wrap(buildAwsValue())
}
object ListJobsFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListJobsFilterCriteria =
      zio.aws.macie2.model.ListJobsFilterCriteria(
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def excludes: Option[List[zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly]]
    def includes: Option[List[zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly]]
    def getExcludes: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly
    ]] = AwsError.unwrapOptionField("excludes", excludes)
    def getIncludes: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly
    ]] = AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria
  ) extends zio.aws.macie2.model.ListJobsFilterCriteria.ReadOnly {
    override val excludes
        : Option[List[zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly]] = scala
      .Option(impl.excludes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.ListJobsFilterTerm.wrap(item)
        }.toList
      )
    override val includes
        : Option[List[zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly]] = scala
      .Option(impl.includes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.ListJobsFilterTerm.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria
  ): zio.aws.macie2.model.ListJobsFilterCriteria.ReadOnly = new Wrapper(impl)
}
