package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters._
final case class ListCustomDataIdentifiersRequest(
    maxResults: Option[__integer] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest = {
    import ListCustomDataIdentifiersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListCustomDataIdentifiersRequest.ReadOnly =
    zio.aws.macie2.model.ListCustomDataIdentifiersRequest.wrap(buildAwsValue())
}
object ListCustomDataIdentifiersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListCustomDataIdentifiersRequest =
      zio.aws.macie2.model.ListCustomDataIdentifiersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[__integer]
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest
  ) extends zio.aws.macie2.model.ListCustomDataIdentifiersRequest.ReadOnly {
    override val maxResults: Option[__integer] =
      scala.Option(impl.maxResults()).map(value => value: __integer)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest
  ): zio.aws.macie2.model.ListCustomDataIdentifiersRequest.ReadOnly =
    new Wrapper(impl)
}
