package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class GetBucketStatisticsRequest(
    accountId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest = {
    import GetBucketStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetBucketStatisticsRequest.ReadOnly =
    zio.aws.macie2.model.GetBucketStatisticsRequest.wrap(buildAwsValue())
}
object GetBucketStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetBucketStatisticsRequest =
      zio.aws.macie2.model
        .GetBucketStatisticsRequest(accountId.map(value => value))
    def accountId: Option[__string]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest
  ) extends zio.aws.macie2.model.GetBucketStatisticsRequest.ReadOnly {
    override val accountId: Option[__string] =
      scala.Option(impl.accountId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest
  ): zio.aws.macie2.model.GetBucketStatisticsRequest.ReadOnly = new Wrapper(
    impl
  )
}
