package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class CreateMemberResponse(arn: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateMemberResponse = {
    import CreateMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateMemberResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateMemberResponse.ReadOnly =
    zio.aws.macie2.model.CreateMemberResponse.wrap(buildAwsValue())
}
object CreateMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateMemberResponse =
      zio.aws.macie2.model.CreateMemberResponse(arn.map(value => value))
    def arn: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateMemberResponse
  ) extends zio.aws.macie2.model.CreateMemberResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateMemberResponse
  ): zio.aws.macie2.model.CreateMemberResponse.ReadOnly = new Wrapper(impl)
}
