package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class BucketServerSideEncryption(
    kmsMasterKeyId: Option[__string] = None,
    `type`: Option[zio.aws.macie2.model.Type] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketServerSideEncryption = {
    import BucketServerSideEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketServerSideEncryption
      .builder()
      .optionallyWith(kmsMasterKeyId.map(value => value: java.lang.String))(
        _.kmsMasterKeyId
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketServerSideEncryption.ReadOnly =
    zio.aws.macie2.model.BucketServerSideEncryption.wrap(buildAwsValue())
}
object BucketServerSideEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketServerSideEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketServerSideEncryption =
      zio.aws.macie2.model.BucketServerSideEncryption(
        kmsMasterKeyId.map(value => value),
        `type`.map(value => value)
      )
    def kmsMasterKeyId: Option[__string]
    def `type`: Option[zio.aws.macie2.model.Type]
    def getKmsMasterKeyId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
    def getType: ZIO[Any, AwsError, zio.aws.macie2.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketServerSideEncryption
  ) extends zio.aws.macie2.model.BucketServerSideEncryption.ReadOnly {
    override val kmsMasterKeyId: Option[__string] =
      scala.Option(impl.kmsMasterKeyId()).map(value => value: __string)
    override val `type`: Option[zio.aws.macie2.model.Type] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.macie2.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketServerSideEncryption
  ): zio.aws.macie2.model.BucketServerSideEncryption.ReadOnly = new Wrapper(
    impl
  )
}
