package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__boolean
import scala.jdk.CollectionConverters._
final case class BucketPolicy(
    allowsPublicReadAccess: Option[__boolean] = None,
    allowsPublicWriteAccess: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketPolicy = {
    import BucketPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketPolicy
      .builder()
      .optionallyWith(
        allowsPublicReadAccess.map(value => value: java.lang.Boolean)
      )(_.allowsPublicReadAccess)
      .optionallyWith(
        allowsPublicWriteAccess.map(value => value: java.lang.Boolean)
      )(_.allowsPublicWriteAccess)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketPolicy.ReadOnly =
    zio.aws.macie2.model.BucketPolicy.wrap(buildAwsValue())
}
object BucketPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketPolicy =
      zio.aws.macie2.model.BucketPolicy(
        allowsPublicReadAccess.map(value => value),
        allowsPublicWriteAccess.map(value => value)
      )
    def allowsPublicReadAccess: Option[__boolean]
    def allowsPublicWriteAccess: Option[__boolean]
    def getAllowsPublicReadAccess: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("allowsPublicReadAccess", allowsPublicReadAccess)
    def getAllowsPublicWriteAccess: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("allowsPublicWriteAccess", allowsPublicWriteAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketPolicy
  ) extends zio.aws.macie2.model.BucketPolicy.ReadOnly {
    override val allowsPublicReadAccess: Option[__boolean] =
      scala.Option(impl.allowsPublicReadAccess()).map(value => value: __boolean)
    override val allowsPublicWriteAccess: Option[__boolean] = scala
      .Option(impl.allowsPublicWriteAccess())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketPolicy
  ): zio.aws.macie2.model.BucketPolicy.ReadOnly = new Wrapper(impl)
}
