package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BucketPermissionConfiguration(
    accountLevelPermissions: Option[
      zio.aws.macie2.model.AccountLevelPermissions
    ] = None,
    bucketLevelPermissions: Option[
      zio.aws.macie2.model.BucketLevelPermissions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration = {
    import BucketPermissionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration
      .builder()
      .optionallyWith(
        accountLevelPermissions.map(value => value.buildAwsValue())
      )(_.accountLevelPermissions)
      .optionallyWith(
        bucketLevelPermissions.map(value => value.buildAwsValue())
      )(_.bucketLevelPermissions)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketPermissionConfiguration.ReadOnly =
    zio.aws.macie2.model.BucketPermissionConfiguration.wrap(buildAwsValue())
}
object BucketPermissionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketPermissionConfiguration =
      zio.aws.macie2.model.BucketPermissionConfiguration(
        accountLevelPermissions.map(value => value.asEditable),
        bucketLevelPermissions.map(value => value.asEditable)
      )
    def accountLevelPermissions
        : Option[zio.aws.macie2.model.AccountLevelPermissions.ReadOnly]
    def bucketLevelPermissions
        : Option[zio.aws.macie2.model.BucketLevelPermissions.ReadOnly]
    def getAccountLevelPermissions: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.AccountLevelPermissions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountLevelPermissions",
      accountLevelPermissions
    )
    def getBucketLevelPermissions: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketLevelPermissions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketLevelPermissions",
      bucketLevelPermissions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration
  ) extends zio.aws.macie2.model.BucketPermissionConfiguration.ReadOnly {
    override val accountLevelPermissions
        : Option[zio.aws.macie2.model.AccountLevelPermissions.ReadOnly] = scala
      .Option(impl.accountLevelPermissions())
      .map(value => zio.aws.macie2.model.AccountLevelPermissions.wrap(value))
    override val bucketLevelPermissions
        : Option[zio.aws.macie2.model.BucketLevelPermissions.ReadOnly] = scala
      .Option(impl.bucketLevelPermissions())
      .map(value => zio.aws.macie2.model.BucketLevelPermissions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration
  ): zio.aws.macie2.model.BucketPermissionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
