package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class BatchGetCustomDataIdentifiersResponse(
    customDataIdentifiers: Option[
      Iterable[zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary]
    ] = None,
    notFoundIdentifierIds: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersResponse = {
    import BatchGetCustomDataIdentifiersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersResponse
      .builder()
      .optionallyWith(
        customDataIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customDataIdentifiers)
      .optionallyWith(
        notFoundIdentifierIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.notFoundIdentifierIds)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse.ReadOnly =
    zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse
      .wrap(buildAwsValue())
}
object BatchGetCustomDataIdentifiersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse =
      zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse(
        customDataIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notFoundIdentifierIds.map(value => value)
      )
    def customDataIdentifiers: Option[
      List[zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary.ReadOnly]
    ]
    def notFoundIdentifierIds: Option[List[__string]]
    def getCustomDataIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("customDataIdentifiers", customDataIdentifiers)
    def getNotFoundIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("notFoundIdentifierIds", notFoundIdentifierIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersResponse
  ) extends zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse.ReadOnly {
    override val customDataIdentifiers: Option[
      List[zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary.ReadOnly]
    ] = scala
      .Option(impl.customDataIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary.wrap(item)
        }.toList
      )
    override val notFoundIdentifierIds: Option[List[__string]] = scala
      .Option(impl.notFoundIdentifierIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersResponse
  ): zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse.ReadOnly =
    new Wrapper(impl)
}
