package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__boolean, __timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BatchGetCustomDataIdentifierSummary(
    arn: Option[__string] = None,
    createdAt: Option[__timestampIso8601] = None,
    deleted: Option[__boolean] = None,
    description: Option[__string] = None,
    id: Option[__string] = None,
    name: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifierSummary = {
    import BatchGetCustomDataIdentifierSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifierSummary
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(deleted.map(value => value: java.lang.Boolean))(_.deleted)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary.ReadOnly =
    zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary
      .wrap(buildAwsValue())
}
object BatchGetCustomDataIdentifierSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifierSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary =
      zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary(
        arn.map(value => value),
        createdAt.map(value => value),
        deleted.map(value => value),
        description.map(value => value),
        id.map(value => value),
        name.map(value => value)
      )
    def arn: Option[__string]
    def createdAt: Option[__timestampIso8601]
    def deleted: Option[__boolean]
    def description: Option[__string]
    def id: Option[__string]
    def name: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeleted: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifierSummary
  ) extends zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val createdAt: Option[__timestampIso8601] =
      scala.Option(impl.createdAt()).map(value => value: __timestampIso8601)
    override val deleted: Option[__boolean] =
      scala.Option(impl.deleted()).map(value => value: __boolean)
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifierSummary
  ): zio.aws.macie2.model.BatchGetCustomDataIdentifierSummary.ReadOnly =
    new Wrapper(impl)
}
