package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class AssumedRole(
    accessKeyId: Option[__string] = None,
    accountId: Option[__string] = None,
    arn: Option[__string] = None,
    principalId: Option[__string] = None,
    sessionContext: Option[zio.aws.macie2.model.SessionContext] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AssumedRole = {
    import AssumedRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AssumedRole
      .builder()
      .optionallyWith(accessKeyId.map(value => value: java.lang.String))(
        _.accessKeyId
      )
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(sessionContext.map(value => value.buildAwsValue()))(
        _.sessionContext
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AssumedRole.ReadOnly =
    zio.aws.macie2.model.AssumedRole.wrap(buildAwsValue())
}
object AssumedRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AssumedRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AssumedRole =
      zio.aws.macie2.model.AssumedRole(
        accessKeyId.map(value => value),
        accountId.map(value => value),
        arn.map(value => value),
        principalId.map(value => value),
        sessionContext.map(value => value.asEditable)
      )
    def accessKeyId: Option[__string]
    def accountId: Option[__string]
    def arn: Option[__string]
    def principalId: Option[__string]
    def sessionContext: Option[zio.aws.macie2.model.SessionContext.ReadOnly]
    def getAccessKeyId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getPrincipalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getSessionContext
        : ZIO[Any, AwsError, zio.aws.macie2.model.SessionContext.ReadOnly] =
      AwsError.unwrapOptionField("sessionContext", sessionContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AssumedRole
  ) extends zio.aws.macie2.model.AssumedRole.ReadOnly {
    override val accessKeyId: Option[__string] =
      scala.Option(impl.accessKeyId()).map(value => value: __string)
    override val accountId: Option[__string] =
      scala.Option(impl.accountId()).map(value => value: __string)
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val principalId: Option[__string] =
      scala.Option(impl.principalId()).map(value => value: __string)
    override val sessionContext
        : Option[zio.aws.macie2.model.SessionContext.ReadOnly] = scala
      .Option(impl.sessionContext())
      .map(value => zio.aws.macie2.model.SessionContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AssumedRole
  ): zio.aws.macie2.model.AssumedRole.ReadOnly = new Wrapper(impl)
}
