package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{
  __long,
  __boolean,
  __timestampIso8601,
  __string
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class S3Object(
    bucketArn: Option[__string] = None,
    eTag: Option[__string] = None,
    extension: Option[__string] = None,
    key: Option[__string] = None,
    lastModified: Option[__timestampIso8601] = None,
    path: Option[__string] = None,
    publicAccess: Option[__boolean] = None,
    serverSideEncryption: Option[zio.aws.macie2.model.ServerSideEncryption] =
      None,
    size: Option[__long] = None,
    storageClass: Option[zio.aws.macie2.model.StorageClass] = None,
    tags: Option[Iterable[zio.aws.macie2.model.KeyValuePair]] = None,
    versionId: Option[__string] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3Object
      .builder()
      .optionallyWith(bucketArn.map(value => value: java.lang.String))(
        _.bucketArn
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(extension.map(value => value: java.lang.String))(
        _.extension
      )
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(publicAccess.map(value => value: java.lang.Boolean))(
        _.publicAccess
      )
      .optionallyWith(serverSideEncryption.map(value => value.buildAwsValue()))(
        _.serverSideEncryption
      )
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3Object.ReadOnly =
    zio.aws.macie2.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.S3Object] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3Object =
      zio.aws.macie2.model.S3Object(
        bucketArn.map(value => value),
        eTag.map(value => value),
        extension.map(value => value),
        key.map(value => value),
        lastModified.map(value => value),
        path.map(value => value),
        publicAccess.map(value => value),
        serverSideEncryption.map(value => value.asEditable),
        size.map(value => value),
        storageClass.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        versionId.map(value => value)
      )
    def bucketArn: Option[__string]
    def eTag: Option[__string]
    def extension: Option[__string]
    def key: Option[__string]
    def lastModified: Option[__timestampIso8601]
    def path: Option[__string]
    def publicAccess: Option[__boolean]
    def serverSideEncryption
        : Option[zio.aws.macie2.model.ServerSideEncryption.ReadOnly]
    def size: Option[__long]
    def storageClass: Option[zio.aws.macie2.model.StorageClass]
    def tags: Option[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]]
    def versionId: Option[__string]
    def getBucketArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
    def getETag: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getExtension: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("extension", extension)
    def getKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("key", key)
    def getLastModified: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getPath: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("path", path)
    def getPublicAccess: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("publicAccess", publicAccess)
    def getServerSideEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSize: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("size", size)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.macie2.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVersionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3Object
  ) extends zio.aws.macie2.model.S3Object.ReadOnly {
    override val bucketArn: Option[__string] =
      scala.Option(impl.bucketArn()).map(value => value: __string)
    override val eTag: Option[__string] =
      scala.Option(impl.eTag()).map(value => value: __string)
    override val extension: Option[__string] =
      scala.Option(impl.extension()).map(value => value: __string)
    override val key: Option[__string] =
      scala.Option(impl.key()).map(value => value: __string)
    override val lastModified: Option[__timestampIso8601] =
      scala.Option(impl.lastModified()).map(value => value: __timestampIso8601)
    override val path: Option[__string] =
      scala.Option(impl.path()).map(value => value: __string)
    override val publicAccess: Option[__boolean] =
      scala.Option(impl.publicAccess()).map(value => value: __boolean)
    override val serverSideEncryption
        : Option[zio.aws.macie2.model.ServerSideEncryption.ReadOnly] = scala
      .Option(impl.serverSideEncryption())
      .map(value => zio.aws.macie2.model.ServerSideEncryption.wrap(value))
    override val size: Option[__long] =
      scala.Option(impl.size()).map(value => value: __long)
    override val storageClass: Option[zio.aws.macie2.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.macie2.model.StorageClass.wrap(value))
    override val tags
        : Option[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.KeyValuePair.wrap(item)
        }.toList
      )
    override val versionId: Option[__string] =
      scala.Option(impl.versionId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3Object
  ): zio.aws.macie2.model.S3Object.ReadOnly = new Wrapper(impl)
}
