package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters._
final case class CreateCustomDataIdentifierRequest(
    clientToken: Option[__string] = None,
    description: Option[__string] = None,
    ignoreWords: Option[Iterable[__string]] = None,
    keywords: Option[Iterable[__string]] = None,
    maximumMatchDistance: Option[__integer] = None,
    name: __string,
    regex: __string,
    severityLevels: Option[Iterable[zio.aws.macie2.model.SeverityLevel]] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest = {
    import CreateCustomDataIdentifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        ignoreWords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ignoreWords)
      .optionallyWith(
        keywords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keywords)
      .optionallyWith(maximumMatchDistance.map(value => value: Integer))(
        _.maximumMatchDistance
      )
      .name(name: java.lang.String)
      .regex(regex: java.lang.String)
      .optionallyWith(
        severityLevels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityLevels)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.CreateCustomDataIdentifierRequest.ReadOnly =
    zio.aws.macie2.model.CreateCustomDataIdentifierRequest.wrap(buildAwsValue())
}
object CreateCustomDataIdentifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateCustomDataIdentifierRequest =
      zio.aws.macie2.model.CreateCustomDataIdentifierRequest(
        clientToken.map(value => value),
        description.map(value => value),
        ignoreWords.map(value => value),
        keywords.map(value => value),
        maximumMatchDistance.map(value => value),
        name,
        regex,
        severityLevels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def clientToken: Option[__string]
    def description: Option[__string]
    def ignoreWords: Option[List[__string]]
    def keywords: Option[List[__string]]
    def maximumMatchDistance: Option[__integer]
    def name: __string
    def regex: __string
    def severityLevels
        : Option[List[zio.aws.macie2.model.SeverityLevel.ReadOnly]]
    def tags: Option[Map[__string, __string]]
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getIgnoreWords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("ignoreWords", ignoreWords)
    def getKeywords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getMaximumMatchDistance: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maximumMatchDistance", maximumMatchDistance)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getRegex: ZIO[Any, Nothing, __string] = ZIO.succeed(regex)
    def getSeverityLevels: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.SeverityLevel.ReadOnly
    ]] = AwsError.unwrapOptionField("severityLevels", severityLevels)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest
  ) extends zio.aws.macie2.model.CreateCustomDataIdentifierRequest.ReadOnly {
    override val clientToken: Option[__string] =
      scala.Option(impl.clientToken()).map(value => value: __string)
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val ignoreWords: Option[List[__string]] = scala
      .Option(impl.ignoreWords())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val keywords: Option[List[__string]] = scala
      .Option(impl.keywords())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val maximumMatchDistance: Option[__integer] =
      scala.Option(impl.maximumMatchDistance()).map(value => value: __integer)
    override val name: __string = impl.name(): __string
    override val regex: __string = impl.regex(): __string
    override val severityLevels
        : Option[List[zio.aws.macie2.model.SeverityLevel.ReadOnly]] = scala
      .Option(impl.severityLevels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.SeverityLevel.wrap(item)
        }.toList
      )
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest
  ): zio.aws.macie2.model.CreateCustomDataIdentifierRequest.ReadOnly =
    new Wrapper(impl)
}
